import React, { useState } from 'react'
import { format, getMonth, getYear } from 'date-fns'
import { nb } from 'date-fns/locale'
import EavisCalendarDaysContainer from './EavisCalendarDaysContainer'
import { Calendar, CalendarNaviBar, CalendarMonthLink, CalendarYearMonthTitle } from './calendar'

const EavisCalendar = () => {
	let nextDisabled = false
	const [month, setMonth] = useState(getMonth(new Date()))
	const [year, setYear] = useState(getYear(new Date()))
	if (isCurrentMonth(year, month)) {
		nextDisabled = true
	}
	const prevHandler = () => {
		if (month === 0) {
			setYear(year - 1)
			setMonth(11)
			return
		}
		setMonth(month - 1)
	}

	const nextHandler = () => {
		if (isCurrentMonth(year, month)) {
			return
		}
		if (month === 11) {
			setYear(year + 1)
			setMonth(0)
			return
		}
		setMonth(month + 1)
	}

	const humanDate = format(new Date(year, month), 'MMMM yyyy', { locale: nb })
	const nextClass = nextDisabled ? 'disabled' : ''
	return (
		<Calendar>
			<CalendarNaviBar>
				<CalendarMonthLink type="button" onClick={prevHandler}>
					forrige
				</CalendarMonthLink>
				<CalendarMonthLink type="button" className={nextClass} onClick={nextHandler}>
					neste
				</CalendarMonthLink>
				<CalendarYearMonthTitle>{humanDate}</CalendarYearMonthTitle>
			</CalendarNaviBar>
			<EavisCalendarDaysContainer year={year} month={month} />
		</Calendar>
	)
}

function isCurrentMonth(year, month) {
	return year === getYear(new Date()) && month === getMonth(new Date())
}

EavisCalendar.propTypes = {}

EavisCalendar.defaultProps = {}

export default EavisCalendar
