import React from 'react'
import PropTypes from 'prop-types'
import classnames from 'classnames'
import { FontIcon } from '@aller/shiny/src/atoms/FontIcon'
import CtaPopupWrapper from './CtaPopupWrapper'
import hasStorage from '../../utils/has-storage'

class CtaPopup extends React.PureComponent {
	constructor(props) {
		super(props)

		this.state = {
			displayContent: false,
			popupCoversFooter: false,
			popupVisible: false,
			userPressedClose: false,
		}
	}

	componentDidMount() {
		if (sessionStorage.getItem('articleVisited') !== 'true') {
			const popupAppear = document.body.offsetHeight / 2 // 50% of document-height

			const footer = document.getElementsByClassName('site-footer')[0]
				? document.getElementsByClassName('site-footer')[0].offsetTop
				: document.body.offsetHeight

			// when to show pop-up
			setInterval(() => {
				// distance from bottom of window to top of page
				const windowBottomBound = window.pageYOffset + window.innerHeight

				// if distance to top is bigger than 50% of the document
				if (windowBottomBound >= popupAppear) {
					this.setState({
						popupVisible: true,
					})
				}

				// if the site footer is in the viewport
				if (windowBottomBound >= footer) {
					this.setState({
						popupCoversFooter: true,
					})
				} else {
					this.setState({
						popupCoversFooter: false,
					})
				}
			}, 250)

			// sessionStorage.setItem('articleVisited', 'true')
		}
	}

	displayContent() {
		// click to view content
		// $('.cta-popup-offer-wrapper').toggleClass('is-hidden')
		// $('.cta-popup-text-wrapper').toggleClass('is-hidden')
		// $('.cta-popup-wrapper').toggleClass('is-visible')
		this.setState({
			displayContent: true,
		})
	}

	hidePopup() {
		if (hasStorage()) {
			sessionStorage.setItem('hasCrossedOutCtaPopup', 'true')
		}

		this.setState({
			userPressedClose: true,
		})
	}

	render() {
		const { ignoreCrossingOut } = this.props
		const { displayContent, popupCoversFooter, popupVisible, userPressedClose } = this.state

		if (hasStorage()) {
			if (sessionStorage.getItem('hasCrossedOutCtaPopup') === 'true') {
				if (!ignoreCrossingOut) {
					return null
				}
			}
		}

		if (userPressedClose) return null

		const popupClasses = classnames({
			'is-open': displayContent,
			'is-closed': !displayContent,
			'is-visible': popupVisible,
			'popup-covers-footer': popupCoversFooter,
		})

		return (
			<CtaPopupWrapper className={popupClasses}>
				<button
					aria-label="Lukk"
					type="button"
					className="btn-close"
					onClick={() => this.hidePopup()}
				>
					<FontIcon className="cta-popup-close-icon" name="close" size={1.8} />
				</button>
				<div className="cta-popup">
					<div className="round-wrapper">
						<div
							id="cta-popup-toggle"
							className={`cta-popup-text-wrapper red ${popupVisible ? 'slide-in-right' : ''}`}
						>
							<button
								type="button"
								className="cta-popup-text"
								onClick={() => this.displayContent()}
							>
								Bli abonnent på <b>Se og Hør</b>
							</button>
						</div>
						<div
							id="cta-popup-image"
							className={`cta-popup-image-wrapper ${popupVisible ? 'fade-in' : ''}`}
						>
							<img
								src="https://styleguide.seher.no/assets/favicon/seher/favicon-228.png"
								alt=""
								className="cta-popup-image"
							/>
						</div>
					</div>
					<div className={`cta-popup-offer-wrapper ${displayContent ? 'is-open' : 'is-closed'}`}>
						<div
							className={`cta-popup-text-wrapper  ${
								displayContent ? 'is-open' : 'is-closed'
							} show-offer`}
						>
							<div className="cta-popup-text show-offer top">
								<b>Bli abonnent på Se og Hør</b>
							</div>
							<a
								href="https://kampanje.allershopping.no/mb-soh-10-249?utm_source=house_soh&utm_medium=banner&utm_campaign=mb-soh-10-249" // eslint-disable-line max-len
								target="_blank"
								rel="noopener noreferrer"
								className="cta-popup-text"
							>
								<img src="https://styleguide.seher.no/assets/covers/ad-offer2.jpg" alt="spar 50%" />
								<div className="cta-popup-text show-offer bottom">
									<b>Kun 249,- for 10 utgaver</b>
									<b className="cta-button">KJØP NÅ</b>
								</div>
							</a>
						</div>
					</div>
				</div>
			</CtaPopupWrapper>
		)
	}
}
CtaPopup.propTypes = {
	ignoreCrossingOut: PropTypes.bool,
}
CtaPopup.defaultProps = {
	ignoreCrossingOut: false,
}

export default CtaPopup
