import React from 'react'
import PropTypes from 'prop-types'
import { format } from 'date-fns'
import { nb } from 'date-fns/locale'
import { TrysilPlug } from '@aller/shiny/src/molecules/TrysilPlug'

const ListItem = ({ timestamp, image, title, url }) => {
	const vewDate = format(new Date(timestamp / 1000), 'd. MMMM yyyy', { locale: nb })
	// Replace every option after imageId with our own
	const goodQualityUrl = image.replace(
		/(?<=imageId=.{8}(?=&)).+/,
		'&x=0&y=0&cropw=100&croph=69.888475836431&width=600&height=340',
	)
	return (
		<TrysilPlug
			column={{ xs: 12 }}
			image={goodQualityUrl}
			url={url}
			ratio={0.5}
			title={title}
			subtitle={vewDate}
		/>
	)
}

ListItem.propTypes = {
	timestamp: PropTypes.number.isRequired,
	image: PropTypes.string.isRequired,
	title: PropTypes.string.isRequired,
	url: PropTypes.string.isRequired,
}

export default ListItem
