import React, { useState, useEffect } from 'react'
import styled from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const Box = styled.div`
	box-sizing: border-box;
	margin: 0 auto;
	display: flex;
	flex-wrap: wrap;
	width: 100%;
	background-color: ${(props: any) => {
		const bg = getColor('background')(props)
		if (bg === 'transparent') {
			return '#fff'
		}
		return bg
	}};
	padding: 1.5rem;
	font-family: ${getVariable('mainFont')};

	@media screen and (max-width: ${(props: any) => props.theme.flexboxgrid.breakpoints.sm}em) {
		padding: 1.5rem 2.9rem;
	}
`

const Title = styled.h1`
	font-size: 1.4rem;
	flex-shrink: 0;
	line-height: 2rem;
	font-weight: ${getVariable('uiWeightBold')};
	color: ${getColor('type')};
	margin: auto 0;
	margin-right: 0.5rem;

	@media screen and (max-width: ${(props: any) => props.theme.flexboxgrid.breakpoints.sm}em) {
		font-size: ${getVariable('headingMediumSize')};
		line-height: ${getVariable('headingMediumLineHeight')};
	}
`

const Body = styled.p`
	margin: auto 0;
	color: ${getColor('type')};
	margin: 0;
	font-size: 1.4rem;
	line-height: 2rem;

	& a {
		color: ${getColor('type')};
	}
`

const CloseButton = styled.button`
	margin-left: auto;
	cursor: pointer;
	padding: 0;
	text-decoration: none;
	display: inline-block;
	text-align: center;
	vertical-align: middle;
	width: 5rem;
	height: 2rem;
	border-radius: 1.8rem;
	border: solid 0.1rem ${getColor('grayTint')};
	background-color: ${getColor('background')};
	color: ${getColor('type')};
	font-weight: ${getVariable('uiWeightBold')};

	&:hover {
		text-decoration: underline;
	}

	@media screen and (max-width: 1230px) {
		margin-left: 0;
		margin-top: 0.5rem;
	}
`

interface Props {
	force?: boolean
}
const lsBrowserWarningKey = 'bw_notified'
const BrowserWarning = ({ force = false }: Props) => {
	const [show, setShow] = useState(false)

	function handleClick() {
		try {
			localStorage.setItem(lsBrowserWarningKey, `${Date.now()}`)
			setShow(false)
		} catch (error) {
			// Do nothing
		}
	}

	useEffect(() => {
		if (typeof localStorage !== 'undefined') {
			try {
				const notifiedOfBrowserWarning = localStorage.getItem(lsBrowserWarningKey)

				/* eslint-disable spaced-comment */
				// @ts-ignore
				const isIE = /*@cc_on!@*/ false || !!document.documentMode

				if (!notifiedOfBrowserWarning && (isIE || force)) {
					setShow(true)
				}
			} catch (error) {
				// Do nothing
			}
		}
	}, [force])
	if (!show) return null
	return (
		<Box>
			<Title>Din nettleser er utdatert!</Title>
			<Body>
				Du bruker en gammel nettleser (Internet Explorer) som ikke lenger vedlikeholdes. For bedre
				sikkerhet og en bedre brukeropplevelse burde du oppdatere.{' '}
				<a
					href="https://www.dinside.no/data/internet-explorer-fortsatt-nest-storst-i-norge/71618956"
					target="_blank"
					rel="noopener noreferrer"
				>
					Les mer hos Dinside
				</a>
				.
			</Body>
			<CloseButton onClick={handleClick}>Lukk</CloseButton>
		</Box>
	)
}

export default BrowserWarning
