import { Component } from 'react'
import BlinkLabrador from '@aller/blink-labrador'

export default class Blink extends Component {
	componentDidMount() {
		window.wolverine = true
		const tracker = new BlinkLabrador()
		tracker.trackPageload()
		tracker.trackPerformance()
		tracker.trackAdInscreen0('.adunit')
		tracker.trackAdInscreen('.adunit')
		tracker.trackActiveTime()
		tracker.trackLinkClicks()
		tracker.trackArticleImpressions('article.preview,article.preview-blink,.article-list>li')
		tracker.trackAdDFP()
		// In timeout because we might re-render stuff on the frontend.
		setTimeout(tracker.trackVideos, 500)

		// Expose blink functions to other modules
		window.trackAdLoad = tracker.trackAdLoad
		window.trackCustom = tracker.trackCustom
		window.trackArticleImpressions = selector => {
			tracker.trackArticleImpressions(selector)
		}
		window.trackAdInscreen0 = selector => {
			tracker.trackAdInscreen0(selector)
		}
		window.trackAdInscreen = selector => {
			tracker.trackAdInscreen(selector)
		}
		window.blinkLabrador = tracker
		window.pageInit = tracker.pageInit
		window.trackPageload = () => {
			tracker.trackPageload()
		}
		window.trackPerformance = () => {
			tracker.trackPerformance()
		}
	}

	render() {
		return null
	}
}
