import { useEffect } from 'react'

/*
	Blink is initialized on page load in our _app component, and on route changes in our _app component.
	This initialization sets adds DOM elements to it's list over things to track,
	however when _app first mounts we do not have any articles or ads in the DOM.
	This provider calls the tracking methods again once (to be used e.g. inside a client-only component)
*/
const TrackingProvider = ({ children }) => {
	useEffect(() => {
		if (
			typeof window !== 'undefined' &&
			typeof window.trackArticleImpressions !== 'undefined' &&
			typeof window.trackAdInscreen0 !== 'undefined' &&
			typeof window.trackAdInscreen !== 'undefined'
		) {
			window.trackArticleImpressions('article.preview,article.preview-blink,.article-list>li')
			window.trackAdInscreen0('.adunit')
			window.trackAdInscreen('.adunit')
		}
	}, [])

	return children
}

export default TrackingProvider
