import styled from 'styled-components'

import { getColor } from '@aller/shiny/src/utils/get-color'

import Screen from '../Screen'

const ArticlesReadSection = styled(Screen)`
	display: flex;
	flex-direction: row;
	flex-wrap: wrap;
	justify-content: space-around;

	background: linear-gradient(110deg, ${getColor('green')} 53%, rgba(0, 0, 0, 0) 30%),
		radial-gradient(
			farthest-corner at 0% 0%,
			${getColor('greenLighter')} 70%,
			${getColor('greenLight')} 70%
		);
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		flex-direction: row;
		justify-content: space-around;
	}
`

export default ArticlesReadSection
