import React from 'react'
import propTypes from 'prop-types'
import createDebug from 'debug'
import onIdle from 'on-idle'

import imageCollectionStyles from './image-collection-styles'
import injectOnce from './inject-once'
import jQuery224 from './jquery-2.2.4'
import styleguideScript from './styleguideScript'

const loadLazysizes = () => import(/* webpackChunkName: "lazysizes" */ 'lazysizes')
const debug = createDebug('wolverine:article')

/* eslint-disable react/no-danger */
class ArticleWithContainedStyleguideStyles extends React.PureComponent {
	componentDidMount() {
		debug('article mounted')
		const { markup } = this.props
		const hasImageCollection =
			markup.includes('image-collection') || markup.includes('cta-popup-wrapper')
		const needsLazysizes = markup.includes('lazyload')
		const needsStyleGuideScripts = hasImageCollection

		if (hasImageCollection) {
			onIdle(() => injectOnce(imageCollectionStyles))
		}

		if (needsLazysizes) {
			loadLazysizes()
			debug('lazysizes has been loaded.')
		}

		if (needsStyleGuideScripts) {
			onIdle(() => {
				// jQuery and next fight over window.module or some other magic property
				injectOnce(jQuery224)
				debug('jQuery 2.4 has been injected separately.')

				injectOnce(styleguideScript)
				debug('The styleguide script has been injected.')
			})
		}
	}

	render() {
		const { markup, css } = this.props

		return (
			<div className="containMe">
				<style dangerouslySetInnerHTML={{ __html: css }} />
				<article dangerouslySetInnerHTML={{ __html: markup }} className="article-entity" />
			</div>
		)
	}
}
/* eslint-enable react/no-danger */
ArticleWithContainedStyleguideStyles.propTypes = {
	markup: propTypes.string,
	css: propTypes.string,
}
ArticleWithContainedStyleguideStyles.defaultProps = {
	markup: '',
	css: '',
}

export default ArticleWithContainedStyleguideStyles
