import styled from 'styled-components'

export const ArchiveContainer = styled.div`
	padding: 3rem 0 4rem 0;
	position: relative;
`

export const ArchiveHeaderStyled = styled.div`
	height: 5rem;
	width: 100%;
	border-bottom: 1px solid black;
	padding: 0 6rem;
	align-items: center;
	display: flex;
`

export const HeaderTitleStyled = styled.h1`
	font-size: 2rem;
	padding: 0;
	margin: 0;
	text-transform: uppercase;
`
export const YearContainerStyled = styled.div``

export const YearItemStyled = styled.div`
	width: 5rem;
	cursor: pointer;
	float: left;
	&:hover {
		text-decoration: underline;
	}
`
export const TitleStyled = styled.h1`
	position: relative;
	font-size: 2rem;
	padding: 3rem 0 1.6rem 0;
	margin: 0;
	text-transform: uppercase;

	&:after {
		width: 100%;
		height: 0.1rem;
		background-color: #ececec;
		content: '';
		display: block;
		position: absolute;
		bottom: 1rem;
		left: 0;
	}
`

export const PlussSign = styled.span`
	font-weight: 1000;
	font-size: 1.4rem;
`
export const PlussTitle = styled.span`
	text-transform: uppercase;
	font-size: 1.2rem;
`
export const PlussContainer = styled.div`
	display: inline-block;
	border: 1px solid #ececec;
	line-height: 1.1rem;
	padding: 0.1rem;
	margin-left: 1rem;
`

export const ErrorContainer = styled.div`
	display: flex;
	justify-content: center;
	align-items: center;
	height: 100vh;
	width: 100vw;
`
export const ArticleLink = styled.a`
	cursor: pointer;
	font-size: 1.6rem;
	display: block;
	padding-bottom: 0.2rem;
	&:hover {
		text-decoration: none;
	}
`

export const SortButtonContainer = styled.div`
	display: flex;
	justify-content: flex-start;
	align-items: center;
	margin-bottom: 1rem;
`

export const SortButton = styled.button`
	text-align: center;
	font-weight: 300;
	font-size: 1.4rem;
	padding: 0.6rem 1.6rem;
	margin: 0;
	width: auto;
	cursor: pointer;
	-webkit-text-decoration: underline;
	background: transparent;
	margin-right: 1rem;
	border: 1px solid #ececec;
	&:focus {
		outline: none;
		border: 1px solid #ececec;
	}
`

export const BackLink = styled.a`
	margin-bottom: 0.8rem;
	display: block;
	text-decoration: none;
`
