import React from 'react'
import propTypes from 'prop-types'
import { SortButton, SortButtonContainer } from './index'

const ArchiveSortButtons = ({ setOrder, orderBy, setOrderDirection, orderDirection }) => {
	const orderDirectionName = orderDirection === true ? 'stigende' : 'synkende'
	const orderByName = orderBy === 'tid' ? 'tid' : 'tittel'
	return (
		<SortButtonContainer>
			<SortButton type="button" onClick={setOrder}>
				Sortert på {orderByName}
			</SortButton>
			<SortButton
				type="button"
				onClick={() => {
					setOrderDirection(!orderDirection)
				}}
			>
				Sortert {orderDirectionName}
			</SortButton>
		</SortButtonContainer>
	)
}

ArchiveSortButtons.propTypes = {
	setOrder: propTypes.func.isRequired,
	setOrderDirection: propTypes.func.isRequired,
	orderBy: propTypes.string.isRequired,
	orderDirection: propTypes.bool.isRequired,
}

export default ArchiveSortButtons
