import React from 'react'
import propTypes from 'prop-types'
import { PlussSign, PlussTitle, PlussContainer, ArticleLink } from './index'

// shows pluss badge if product length is not 0 - might not be the best solution, as well as markup,
// so refactor it
function renderPluss(products) {
	if (products.length > 0) {
		return (
			<PlussContainer>
				<PlussSign>+</PlussSign>
				<PlussTitle> pluss</PlussTitle>
			</PlussContainer>
		)
	}
	return null
}

const ArchiveArticleItem = ({ article, domain }) => {
	return (
		<div key={article.id}>
			<ArticleLink href={domain + article.publishedURL} rel="noopener noreferrer" target="_blank">
				{article.title}
			</ArticleLink>
			{renderPluss(article.product)}
		</div>
	)
}

ArchiveArticleItem.propTypes = {
	article: propTypes.shape({
		id: propTypes.oneOfType([propTypes.number, propTypes.string]).isRequired,
		publishedURL: propTypes.string.isRequired,
		title: propTypes.string.isRequired,
		product: propTypes.array.isRequired,
	}).isRequired,
	domain: propTypes.string.isRequired,
}

export default ArchiveArticleItem
