// TODO: tester av annonser
import React from 'react'
import propTypes from 'prop-types'

import dynamic from 'next/dynamic'

const TopBanner = dynamic(() => import(/* webpackChunkName: "AdTopBanner" */ './TopBanner'))
const Smartbanner = dynamic(() => import(/* webpackChunkName: "AdSmartbanner" */ './Smartbanner'))
const Banner = dynamic(() => import(/* webpackChunkName: "AdBanner" */ './Banner'))
const GenericAd = dynamic(() => import(/* webpackChunkName: "AdGeneric" */ './Generic'))
const NetboardAd = dynamic(() => import(/* webpackChunkName: "AdNetboard" */ './Netboard'))

const MediumRectangle = dynamic(() =>
	import(/* webpackChunkName: "AdMediumRectangle" */ './MediumRectangle'),
)
const Fullscreen = dynamic(() => import(/* webpackChunkName: "AdFullscreen" */ './Fullscreen'))
const FullscreenTest = dynamic(() =>
	import(/* webpackChunkName: "AdFullscreenTest" */ './Fullscreentest'),
)
const Sticky = dynamic(() => import(/* webpackChunkName: "AdSticky" */ './Sticky'))
const Blank = dynamic(() => import(/* webpackChunkName: "AdBlank" */ './Blank'))

const AdBundle = ({ id, ...props }) => {
	if (id.startsWith('ad-topbanner')) {
		return <TopBanner id={id} {...props} />
	}
	if (id.startsWith('ad-banner')) {
		return <Banner id={id} {...props} />
	}
	if (id.startsWith('ad-smartbanner')) {
		return <Smartbanner id={id} {...props} />
	}
	if (id.startsWith('ad-netboard')) {
		return <NetboardAd id={id} {...props} />
	}
	if (id.startsWith('ad-leaderboard')) {
		return <GenericAd id={id} {...props} />
	}
	if (id.startsWith('ad-medium-rectangle')) {
		return <MediumRectangle id={id} {...props} />
	}
	if (id.startsWith('ad-fullscreen')) {
		return <Fullscreen id={id} {...props} />
	}
	if (id.startsWith('ad-test-fullscreen')) {
		return <FullscreenTest id={id} {...props} />
	}
	if (id.startsWith('ad-skyscraper-right')) {
		return <Sticky id={id} {...props} />
	}
	if (id.startsWith('ad-skyscraper-right')) {
		return <Sticky id={id} {...props} />
	}
	if (id.startsWith('ad-sticky-right')) {
		return <Sticky id={id} {...props} />
	}
	return <Blank />
}
AdBundle.propTypes = {
	id: propTypes.string,
}
AdBundle.defaultProps = {
	id: null,
}

export default props => <AdBundle {...props} />
