import React from 'react'
import PropTypes from 'prop-types'

export default class AdSettingsCogHack extends React.Component {
	componentDidMount() {
		if (window.googletag && window.googletag.cmd) {
			window.FIX_ADS = window.FIX_ADS || {}
			window.googletag.cmd.push(this.addDialogOnAdSettingsCog.bind(this))
		}
	}

	addDialogOnAdSettingsCog() {
		const { openModal } = this.props

		window.googletag.pubads().addEventListener('slotRenderEnded', event => {
			const adId = event.slot.getSlotElementId()
			if (window.FIX_ADS[adId] === true) {
				return
			}
			window.FIX_ADS[adId] = true

			if (event.isEmpty) {
				return
			}
			const node = document.querySelector(`.containMe #${adId}`)
			if (node) {
				node.addEventListener('click', openModal, false)
			}
		})
	}

	render() {
		return null
	}
}

AdSettingsCogHack.propTypes = {
	openModal: PropTypes.func.isRequired,
}
