import React from 'react'
import PropTypes from 'prop-types'
import { WallpaperAd } from '@aller/shiny/src/molecules/WallpaperAd'

import AdSlot from './AdSlot'

const TopBanner = ({ id }) => {
	return (
		<AdSlot
			adSlotProps={{
				id,
			}}
			rootMargin="400px"
			wrapperProps={{
				width: '980px',
				height: '300px',
				shouldHideAttribution: false,
			}}
			wrapper={WallpaperAd}
		/>
	)
}

TopBanner.propTypes = {
	id: PropTypes.string.isRequired,
}

export default TopBanner
