import React from 'react'
import PropTypes from 'prop-types'
import { StickyAd } from '@aller/shiny/src/molecules/StickyAd'

import AdSlot from './AdSlot'

const Sticky = ({ id }) => {
	return (
		<AdSlot
			adSlotProps={{
				id,
			}}
			wrapperProps={{
				width: '300px',
				height: '600px',
				sticky: 'right',
				shouldHideAttribution: false,
			}}
			wrapper={StickyAd}
			type="sticky"
		/>
	)
}

Sticky.propTypes = {
	id: PropTypes.string.isRequired,
}

export default Sticky
