import React from 'react'
import PropTypes from 'prop-types'

import { GenericAd } from '@aller/shiny/src/molecules/GenericAd'
import Col from '../Col'
import XavierArticles from '../XavierArticles'
import { XavierContext } from '../../store/xavier'
import MostRead from '../MostRead'

import AdSlot from './AdSlot'

const NetboardXavierArticles = ({ idNumber }) => {
	return (
		<XavierContext.Consumer>
			{context => (
				<Col
					style={{
						flexDirection: 'column',
						padding: 0,
					}}
					md={4}
				>
					<XavierArticles
						fontSizeOverride={1.9}
						context={context}
						ratio={0.47}
						counter={idNumber}
					/>
					<XavierArticles
						fontSizeOverride={1.9}
						context={context}
						ratio={0.47}
						counter={idNumber + 1}
					/>
				</Col>
			)}
		</XavierContext.Consumer>
	)
}

NetboardXavierArticles.propTypes = {
	idNumber: PropTypes.number.isRequired,
}

const Netboard = ({ elementCounter }) => {
	const adSlot = `ad-netboard${elementCounter.netboard}`
	return (
		<>
			{elementCounter.netboard % 2 !== 0 && (
				<AdSlot
					adSlotProps={{ id: adSlot }}
					wrapperProps={{
						width: '580px',
						height: '400px',
					}}
					wrapper={GenericAd}
					rootMargin="200px"
				/>
			)}
			{elementCounter.netboard === 1 ? (
				<MostRead />
			) : (
				<NetboardXavierArticles
					netboardCounter={elementCounter.netboard}
					idNumber={elementCounter.xavierArticle}
				/>
			)}
			{elementCounter.netboard % 2 === 0 && (
				<AdSlot
					adSlotProps={{ id: adSlot }}
					wrapperProps={{
						width: '580px',
						height: '400px',
					}}
					wrapper={GenericAd}
					rootMargin="200px"
				/>
			)}
		</>
	)
}

Netboard.propTypes = {
	elementCounter: PropTypes.shape({
		netboard: PropTypes.number,
		xavierArticle: PropTypes.number,
	}).isRequired,
}

export default Netboard
