import React, { PureComponent } from 'react'
import propTypes from 'prop-types'
import debug from 'debug'

import { Bling as GPT } from 'react-gpt'
import { AdSettingsCog } from '@aller/shiny/src/atoms/AdSettingsCog'
import { AdsContext } from '../../store/ads'

const log = debug('ads')

class InnerAd extends PureComponent {
	render() {
		const {
			style,
			onMediaQueryChange,
			id,
			adUnit,
			sizes,
			lazyload,
			collapse,
			outofpage,
			targeting,
			sizemapping,
			handleOnSlotRenderEnded,
			handleOnSlotLoad,
			showSettingsCog,
		} = this.props

		const sizeMappings = []
		if (sizemapping) {
			sizemapping.forEach(el => {
				try {
					sizeMappings.push({
						viewport: JSON.parse(el.viewport),
						slot: JSON.parse(el.slot),
					})
				} catch (e) {
					log(`Not valid sizemapping. Using default 980x300. Error: ${e}`)
					sizeMappings.length = 0
					sizeMappings.push({
						viewport: [0, 0],
						slot: [980, 300],
					})
				}
			})
		}

		const parsedSizes = [...JSON.parse(sizes)]

		return (
			<AdsContext.Consumer>
				{context => (
					<>
						{showSettingsCog && <AdSettingsCog onClick={context.openModal} />}
						<GPT
							id={id}
							adUnitPath={adUnit}
							slotSize={parsedSizes.length > 0 ? parsedSizes : null}
							renderWhenViewable={lazyload}
							collapseEmptyDiv={collapse}
							outOfPage={outofpage}
							targeting={JSON.parse(targeting)}
							sizeMapping={sizeMappings.length > 0 ? sizeMappings : null}
							onSlotRenderEnded={slot => handleOnSlotRenderEnded(slot, id, context)}
							onSlotOnload={slot => handleOnSlotLoad(slot)}
							onMediaQueryChange={onMediaQueryChange || null}
							style={style || null}
							viewableThreshold={0}
						/>
					</>
				)}
			</AdsContext.Consumer>
		)
	}
}
InnerAd.propTypes = {
	adUnit: propTypes.string.isRequired,
	id: propTypes.string.isRequired,
	collapse: propTypes.bool,
	handleOnSlotLoad: propTypes.func,
	handleOnSlotRenderEnded: propTypes.func,
	lazyload: propTypes.bool,
	onMediaQueryChange: propTypes.func,
	outofpage: propTypes.bool,
	showSettingsCog: propTypes.bool.isRequired,
	sizemapping: propTypes.arrayOf(
		propTypes.shape({
			viewport: propTypes.string,
			slot: propTypes.string,
		}),
	),
	sizes: propTypes.string.isRequired,
	style: propTypes.shape(),
	targeting: propTypes.string,
}

InnerAd.defaultProps = {
	collapse: false,
	handleOnSlotLoad: () => null,
	handleOnSlotRenderEnded: () => null,
	lazyload: true,
	onMediaQueryChange: () => null,
	outofpage: false,
	sizemapping: null,
	style: null,
	targeting: '',
}

export default InnerAd
