import { themes as shinyThemes } from '@aller/shiny/src/themes'

import { ShinyThemeProvider } from '../../components/LoganThemeProvider'

const themes = Object.values(shinyThemes).map(theme => ({
	name: theme.name,
	props: {
		theme
	},
	default: theme.name === 'Default'
}))


export const contexts = [
  {
    icon: 'paintbrush', // a icon displayed in the Storybook toolbar to control contextual props
    title: 'Themes', // an unique name of a contextual environment
    components: [
      // an array of components that is going to be injected to wrap stories
      /* Styled-components ThemeProvider, */
			/* Material-ui ThemeProvider, */
			ShinyThemeProvider
    ],
    params: themes,
    options: {
      deep: true, // pass the `props` deeply into all wrapping components
      disable: false, // disable this contextual environment completely
      cancelable: false, // allow this contextual environment to be opt-out optionally in toolbar
    },
  },
  /* ... */ // multiple contexts setups are supported
];
