# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pycardano', 'pycardano.backend', 'pycardano.crypto']

package_data = \
{'': ['*']}

install_requires = \
['PyNaCl>=1.4.0,<2.0.0',
 'blockfrost-python==0.4.4',
 'cbor2>=5.4.2,<6.0.0',
 'typeguard>=2.13.3,<3.0.0',
 'websocket-client>=1.2.3,<2.0.0']

setup_kwargs = {
    'name': 'pycardano',
    'version': '0.4.1',
    'description': 'A Cardano library in Python',
    'long_description': '## PyCardano\n\n[![PyPi version](https://badgen.net/pypi/v/pycardano)](https://pypi.python.org/pypi/pycardano/)\n[![PyPI pyversions](https://img.shields.io/pypi/pyversions/pycardano)](https://pypi.python.org/pypi/pycardano/)\n[![PyPI download month](https://img.shields.io/pypi/dm/pycardano)](https://pypi.python.org/pypi/pycardano/)\n[![Discord](https://img.shields.io/discord/949404918903631923.svg?label=chat&logo=discord&logoColor=ffffff&color=7389D8&labelColor=6A7EC2)](https://discord.gg/qT9Mn9xjgz)\n\n[![PyCardano](https://github.com/cffls/pycardano/actions/workflows/main.yml/badge.svg)](https://github.com/cffls/pycardano/actions/workflows/main.yml)\n[![codecov](https://codecov.io/gh/cffls/pycardano/branch/main/graph/badge.svg?token=62N0IL9IMQ)](https://codecov.io/gh/cffls/pycardano)\n[![Documentation Status](https://readthedocs.org/projects/pycardano/badge/?version=latest)](https://pycardano.readthedocs.io/en/latest/?badge=latest)\n\n\nPyCardano is a Cardano library written in Python. It allows users to create and sign transactions without \ndepending on third-party Cardano serialization tools, such as\n[cardano-cli](https://github.com/input-output-hk/cardano-node#cardano-cli) and \n[cardano-serialization-lib](https://github.com/Emurgo/cardano-serialization-lib), making it a lightweight library, which \nis simple and fast to set up in all types of environments.\n\nCurrent goal of this project is to enable developers to write off-chain code and tests in pure Python for Plutus DApps.\nNevertheless, we see the potential in expanding this project to a full Cardano node client, which \ncould be beneficial for faster R&D iterations.\n\n### Table of contents\n\n- [Features](#features)\n- [Installation](#installation)\n- [Documentation](#documentation)\n- [Examples](#examples)\n  - [Full stack DApp](#full-stack-dapp)\n  - [Transaction creation and signing](#transaction-creation-and-signing)\n- [Development](#development)\n  - [Workspace setup](#workspace-setup)\n  - [Test](#test)\n  - [Test coverage](#test-coverage)\n- [Style guidelines](#style-guidelines)\n- [Docs generation](#docs-generation)\n- [Sponsors](#sponsors-heart)\n\n### Features\n\n- [x] Shelly address\n- [x] Transaction builder\n- [x] Transaction signing\n- [x] Multi-asset\n- [X] Chain backend integration\n- [X] Fee calculation\n- [X] UTxO selection\n- [X] Native script\n- [X] Native token\n- [X] Metadata\n- [ ] Plutus script\n- [ ] Mnemonic \n- [ ] Byron Address\n- [ ] Reward withdraw\n- [ ] HD Wallet\n- [ ] Staking certificates\n- [ ] Protocol proposal update\n\n\n### Installation\n\nInstall the library using [pip](https://pip.pypa.io/en/stable/):\n\n`pip install pycardano`\n\n### Documentation\n\nhttps://pycardano.readthedocs.io/en/latest/\n\n### Examples\n\n#### Full stack DApp\n\nA full stack testnet DApp is hosted on replit: https://pycardano.cffls.repl.co/\n\nTo learn more details, go to the [DApp page](https://github.com/cffls/pycardano/tree/main/examples/full_stack).\n\n#### Transaction creation and signing\n\n```python\n"""Build a transaction using transaction builder"""\n\nfrom pycardano import *\n\n# Use testnet\nnetwork = Network.TESTNET\n\n# Read keys to memory\n# Assume there is a payment.skey file sitting in current directory\npsk = PaymentSigningKey.load("payment.skey")\n# Assume there is a stake.skey file sitting in current directory\nssk = StakeSigningKey.load("stake.skey")\n\npvk = PaymentVerificationKey.from_signing_key(psk)\nsvk = StakeVerificationKey.from_signing_key(ssk)\n\n# Derive an address from payment verification key and stake verification key\naddress = Address(pvk.hash(), svk.hash(), network)\n\n# Create a BlockFrost chain context\ncontext = BlockFrostChainContext("your_blockfrost_project_id", network)\n\n# Create a transaction builder\nbuilder = TransactionBuilder(context)\n\n# Tell the builder that transaction input will come from a specific address, assuming that there are some ADA and native\n# assets sitting at this address. "add_input_address" could be called multiple times with different address.\nbuilder.add_input_address(address)\n\n# Get all UTxOs currently sitting at this address\nutxos = context.utxos(str(address))\n\n# We can also tell the builder to include a specific UTxO in the transaction.\n# Similarly, "add_input" could be called multiple times.\nbuilder.add_input(utxos[0])\n\n# Send 1.5 ADA and a native asset (CHOC) in quantity of 2000 to an address.\nbuilder.add_output(\n    TransactionOutput(\n        Address.from_primitive(\n            "addr_test1vrm9x2zsux7va6w892g38tvchnzahvcd9tykqf3ygnmwtaqyfg52x"\n        ),\n        Value.from_primitive(\n            [\n                1500000,\n                {\n                    bytes.fromhex(\n                        "57fca08abbaddee36da742a839f7d83a7e1d2419f1507fcbf3916522"  # Policy ID\n                    ): {\n                        b"CHOC": 2000  # Asset name and amount\n                    }\n                },\n            ]\n        ),\n    )\n)\n\n# We can add multiple outputs, similar to what we can do with inputs.\n# Send 2 ADA and a native asset (CHOC) in quantity of 200 to ourselves\nbuilder.add_output(\n    TransactionOutput(\n        address,\n        Value.from_primitive(\n            [\n                2000000,\n                {\n                    bytes.fromhex(\n                        "57fca08abbaddee36da742a839f7d83a7e1d2419f1507fcbf3916522"  # Policy ID\n                    ): {\n                        b"CHOC": 200  # Asset name and amount\n                    }\n                },\n            ]\n        ),\n    )\n)\n\n# Create final signed transaction\nsigned_tx = builder.build_and_sign([psk], change_address=address)\n\n# Submit signed transaction to the network\ncontext.submit_tx(signed_tx.to_cbor())\n\n```\n\nSee more usages under [examples](https://github.com/cffls/pycardano/tree/main/examples).\n\n\n-----------------\n\n### Development\n\n#### Workspace setup\n\nClone the repository:\n\n`git clone https://github.com/cffls/pycardano.git`\n\nPyCardano uses [poetry](https://python-poetry.org/) to manage its dependencies. \nInstall poetry for osx / linux / bashonwindows:\n\n`curl -sSL https://install.python-poetry.org | python3 -`\n\nGo to [poetry installation](https://python-poetry.org/docs/#installation) for more details. \n\n\nChange directory into the repo, install all dependencies using poetry, and you are all set!\n\n`cd pycardano && poetry install`\n\nWhen testing or running any program, it is recommended to enter \na [poetry shell](https://python-poetry.org/docs/cli/#shell) in which all python dependencies are automatically \nconfigured: `poetry shell`.\n\n\n#### Test\n\nPyCardano uses [pytest](https://docs.pytest.org/en/6.2.x/) for unit testing.\n\nRun all tests:\n`make test`\n\nRun all tests in a specific test file:\n`poetry run pytest test/pycardano/test_transaction.py`\n\nRun a specific test function:\n`poetry run pytest -k "test_transaction_body"`\n\nRun a specific test function in a test file:\n`poetry run pytest test/pycardano/test_transaction.py -k "test_transaction_body"`\n\n#### Test coverage\n\nWe use [Coverage](https://coverage.readthedocs.io/en/latest/) to calculate the test coverage.\n\nTest coverage could be generated by: `make cov`\n\nA html report could be generated and opened in browser by: `make cov-html`\n\n### Style guidelines\n\nThe package uses \n[Google style](https://sphinxcontrib-napoleon.readthedocs.io/en/latest/example_google.html) docstring.\n\nCode could be formatted with command: `make format`\n\nThe code style could be checked by [flake8](https://flake8.pycqa.org/en/latest/): `make qa`\n\n### Docs generation\n\nThe majority of package documentation is created by the docstrings in python files. \nWe use [sphinx](https://www.sphinx-doc.org/en/master/) with \n[Read the Docs theme](https://sphinx-rtd-theme.readthedocs.io/en/stable/) to generate the \nhtml pages.\n\nBuild docs and open the docs in browser: \n\n`make docs`\n\n-----------------\n\n## Sponsors :heart:\n\n<p align="left">\n  <a href="https://www.blockery.io/"><img src="https://avatars.githubusercontent.com/u/97766045?s=60&v=4"/></a>\n</p>\n',
    'author': 'Jerry',
    'author_email': 'jerry@staking247.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cffls/pycardano',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
