'''
exceptions.py: exceptions defined by CommonPy

Authors
-------

Michael Hucka <mhucka@caltech.edu> -- Caltech Library

Copyright
---------

Copyright (c) 2020 by the California Institute of Technology.  This code is
open-source software released under a 3-clause BSD license.  Please see the
file "LICENSE" for more information.
'''


# Base class.
# .............................................................................
# The base class makes it possible to use a single test to distinguish
# between exceptions generated by CommonPy code and exceptions generated by
# something else.

class CommonPyException(Exception):
    '''Base class for CommonPy exceptions.'''
    pass


# Exception classes.
# .............................................................................

class Interrupted(CommonPyException):
    '''The user elected to cancel/quit the program.'''
    pass

class NetworkFailure(CommonPyException):
    '''Unrecoverable problem involving network operations.'''
    pass

class ServiceFailure(CommonPyException):
    '''Unrecoverable problem involving a remote service.'''
    pass

class AuthenticationFailure(CommonPyException):
    '''Problem obtaining or using authentication credentials.'''
    pass

class NoContent(CommonPyException):
    '''No content found at the given location.'''
    pass

class RateLimitExceeded(CommonPyException):
    '''The service flagged reports that its rate limits have been exceeded.'''
    pass

class InternalError(CommonPyException):
    '''Unrecoverable problem involving commonpy itself.'''
    pass
