# Build a Singularity image during the CI process

This example is based on [this project](https://gitlab.com/singularityhub/gitlab-ci) ([https://zenodo.org/record/3834833](https://zenodo.org/record/3834833)).
To be able to include the following code snippet into your `.gitlab-ci.yml` file, you should check the License
compatibility of your project and the one from which this snippet was taken (an example of how license a project with
**two permissive Open Source** licenses can be found [here](
https://gitlab.in2p3.fr/escape2020/wp3/template_project_escape#license)).


This code snippet

 - Builds a Singularity image during the CI process.
 - Makes available the created artifact (the image) to be used in the next CI stages.

**PLEASE NOTE**
 - You should provide the Singularity recipe (`Singularity`) and add it to a `Singularity` directory in the
root directory of your project.
 - The image will be built using  **Singularity v2.6**.


```yaml
stages:
  - build_container

build_singularity:
  stage: build_container
  image: singularityware/singularity:gitlab-2.6
  script:
    - export IMAGE_NAME=$CI_PROJECT_NAME  # Choose the name of the image
    - singularity build $IMAGE_NAME.simg Singularity/Singularity

    - mkdir -p container_build && cp *.simg container_build
    - mkdir -p container_build && cp Singularity/Singularity container_build
    - ls container_build
  artifacts:
    paths:
      - container_build/Singularity.simg
      - container_build/Singularity
  only:
    - tags
```
