# this is adapted from https://github.com/astropy/astropy/blob/master/astropy/version.py
# see https://github.com/astropy/astropy/pull/10774 for a discussion on why this needed.
import warnings

try:
    try:
        from ._dev_version import version
    except ImportError:
        from ._version import __version__ as version
except Exception as e:
    warnings.warn(
        "Could not determine eossr version; this indicates a broken installation."
        " Install eossr from PyPI, a local git repository or using "
        " pip install git+https://gitlab.in2p3.fr/escape2020/wp3/eossr@VERSION "
        " Installing gitlab's autogenerated source release tarballs "
        " does not include version information and should be avoided."
        f"Exception Error: {e}"
    )
    version = "0.0.0"

__version__ = version
