"""
    Elastic Email REST API

    This API is based on the REST API architecture, allowing the user to easily manage their data with this resource-based approach.    Every API call is established on which specific request type (GET, POST, PUT, DELETE) will be used.    The API has a limit of 20 concurrent connections and a hard timeout of 600 seconds per request.    To start using this API, you will need your Access Token (available <a target=\"_blank\" href=\"https://elasticemail.com/account#/settings/new/manage-api\">here</a>). Remember to keep it safe. Required access levels are listed in the given request’s description.    This is the documentation for REST API. If you’d like to read our legacy documentation regarding Web API v2 click <a target=\"_blank\" href=\"https://api.elasticemail.com/public/help\">here</a>.    Downloadable library clients can be found in our Github repository <a target=\"_blank\" href=\"https://github.com/ElasticEmail?tab=repositories&q=%22rest+api%22+in%3Areadme\">here</a>  # noqa: E501

    The version of the OpenAPI document: 4.0.0
    Contact: support@elasticemail.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from ElasticEmail.api_client import ApiClient, Endpoint as _Endpoint
from ElasticEmail.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from ElasticEmail.model.event_type import EventType
from ElasticEmail.model.export_link import ExportLink
from ElasticEmail.model.export_status import ExportStatus
from ElasticEmail.model.recipient_event import RecipientEvent


class EventsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __events_by_transactionid_get(
            self,
            transactionid,
            **kwargs
        ):
            """Load Email Events  # noqa: E501

            Returns a log of delivery events for the specific transaction ID. Required Access Level: ViewReports  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.events_by_transactionid_get(transactionid, async_req=True)
            >>> result = thread.get()

            Args:
                transactionid (str): ID number of transaction

            Keyword Args:
                _from (datetime, none_type): Starting date for search in YYYY-MM-DDThh:mm:ss format.. [optional]
                to (datetime, none_type): Ending date for search in YYYY-MM-DDThh:mm:ss format.. [optional]
                order_by (dict): [optional]
                limit (int): Maximum number of returned items.. [optional]
                offset (int): How many items should be returned ahead.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [RecipientEvent]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transactionid'] = \
                transactionid
            return self.call_with_http_info(**kwargs)

        self.events_by_transactionid_get = _Endpoint(
            settings={
                'response_type': ([RecipientEvent],),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/events/{transactionid}',
                'operation_id': 'events_by_transactionid_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transactionid',
                    '_from',
                    'to',
                    'order_by',
                    'limit',
                    'offset',
                ],
                'required': [
                    'transactionid',
                ],
                'nullable': [
                    '_from',
                    'to',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transactionid':
                        (str,),
                    '_from':
                        (datetime, none_type,),
                    'to':
                        (datetime, none_type,),
                    'order_by':
                        (dict,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'transactionid': 'transactionid',
                    '_from': 'from',
                    'to': 'to',
                    'order_by': 'orderBy',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'transactionid': 'path',
                    '_from': 'query',
                    'to': 'query',
                    'order_by': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__events_by_transactionid_get
        )

        def __events_channels_by_name_export_post(
            self,
            name,
            **kwargs
        ):
            """Export Channel Events  # noqa: E501

            Export delivery events log information to the specified file format. Required Access Level: Export  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.events_channels_by_name_export_post(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str): Name of selected channel.

            Keyword Args:
                event_types ([EventType]): Types of Events to return. [optional]
                _from (datetime, none_type): Starting date for search in YYYY-MM-DDThh:mm:ss format.. [optional]
                to (datetime, none_type): Ending date for search in YYYY-MM-DDThh:mm:ss format.. [optional]
                file_format (dict): Format of the exported file. [optional]
                compression_format (dict): FileResponse compression format. None or Zip.. [optional]
                file_name (str): Name of your file including extension.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ExportLink
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.events_channels_by_name_export_post = _Endpoint(
            settings={
                'response_type': (ExportLink,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/events/channels/{name}/export',
                'operation_id': 'events_channels_by_name_export_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'event_types',
                    '_from',
                    'to',
                    'file_format',
                    'compression_format',
                    'file_name',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                    '_from',
                    'to',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'event_types':
                        ([EventType],),
                    '_from':
                        (datetime, none_type,),
                    'to':
                        (datetime, none_type,),
                    'file_format':
                        (dict,),
                    'compression_format':
                        (dict,),
                    'file_name':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'event_types': 'eventTypes',
                    '_from': 'from',
                    'to': 'to',
                    'file_format': 'fileFormat',
                    'compression_format': 'compressionFormat',
                    'file_name': 'fileName',
                },
                'location_map': {
                    'name': 'path',
                    'event_types': 'query',
                    '_from': 'query',
                    'to': 'query',
                    'file_format': 'query',
                    'compression_format': 'query',
                    'file_name': 'query',
                },
                'collection_format_map': {
                    'event_types': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__events_channels_by_name_export_post
        )

        def __events_channels_by_name_get(
            self,
            name,
            **kwargs
        ):
            """Load Channel Events  # noqa: E501

            Returns a log of delivery events filtered by specified parameters. Required Access Level: ViewReports  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.events_channels_by_name_get(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str): Name of selected channel.

            Keyword Args:
                event_types ([EventType]): Types of Events to return. [optional]
                _from (datetime, none_type): Starting date for search in YYYY-MM-DDThh:mm:ss format.. [optional]
                to (datetime, none_type): Ending date for search in YYYY-MM-DDThh:mm:ss format.. [optional]
                order_by (dict): [optional]
                limit (int): How many items to load. Maximum for this request is 1000 items. [optional]
                offset (int): How many items should be returned ahead.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [RecipientEvent]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.events_channels_by_name_get = _Endpoint(
            settings={
                'response_type': ([RecipientEvent],),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/events/channels/{name}',
                'operation_id': 'events_channels_by_name_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'event_types',
                    '_from',
                    'to',
                    'order_by',
                    'limit',
                    'offset',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                    '_from',
                    'to',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'event_types':
                        ([EventType],),
                    '_from':
                        (datetime, none_type,),
                    'to':
                        (datetime, none_type,),
                    'order_by':
                        (dict,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'name': 'name',
                    'event_types': 'eventTypes',
                    '_from': 'from',
                    'to': 'to',
                    'order_by': 'orderBy',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'name': 'path',
                    'event_types': 'query',
                    '_from': 'query',
                    'to': 'query',
                    'order_by': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                    'event_types': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__events_channels_by_name_get
        )

        def __events_channels_export_by_id_status_get(
            self,
            id,
            **kwargs
        ):
            """Check Channel Export Status  # noqa: E501

            Check the current status of the channel export. Required Access Level: Export  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.events_channels_export_by_id_status_get(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): ID of the exported file

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ExportStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.events_channels_export_by_id_status_get = _Endpoint(
            settings={
                'response_type': (ExportStatus,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/events/channels/export/{id}/status',
                'operation_id': 'events_channels_export_by_id_status_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__events_channels_export_by_id_status_get
        )

        def __events_export_by_id_status_get(
            self,
            id,
            **kwargs
        ):
            """Check Export Status  # noqa: E501

            Check the current status of the export. Required Access Level: Export  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.events_export_by_id_status_get(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): ID of the exported file

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ExportStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.events_export_by_id_status_get = _Endpoint(
            settings={
                'response_type': (ExportStatus,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/events/export/{id}/status',
                'operation_id': 'events_export_by_id_status_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__events_export_by_id_status_get
        )

        def __events_export_post(
            self,
            **kwargs
        ):
            """Export Events  # noqa: E501

            Export delivery events log information to the specified file format. Required Access Level: Export  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.events_export_post(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                event_types ([EventType]): Types of Events to return. [optional]
                _from (datetime, none_type): Starting date for search in YYYY-MM-DDThh:mm:ss format.. [optional]
                to (datetime, none_type): Ending date for search in YYYY-MM-DDThh:mm:ss format.. [optional]
                file_format (dict): Format of the exported file. [optional]
                compression_format (dict): FileResponse compression format. None or Zip.. [optional]
                file_name (str): Name of your file including extension.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ExportLink
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.events_export_post = _Endpoint(
            settings={
                'response_type': (ExportLink,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/events/export',
                'operation_id': 'events_export_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_types',
                    '_from',
                    'to',
                    'file_format',
                    'compression_format',
                    'file_name',
                ],
                'required': [],
                'nullable': [
                    '_from',
                    'to',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_types':
                        ([EventType],),
                    '_from':
                        (datetime, none_type,),
                    'to':
                        (datetime, none_type,),
                    'file_format':
                        (dict,),
                    'compression_format':
                        (dict,),
                    'file_name':
                        (str,),
                },
                'attribute_map': {
                    'event_types': 'eventTypes',
                    '_from': 'from',
                    'to': 'to',
                    'file_format': 'fileFormat',
                    'compression_format': 'compressionFormat',
                    'file_name': 'fileName',
                },
                'location_map': {
                    'event_types': 'query',
                    '_from': 'query',
                    'to': 'query',
                    'file_format': 'query',
                    'compression_format': 'query',
                    'file_name': 'query',
                },
                'collection_format_map': {
                    'event_types': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__events_export_post
        )

        def __events_get(
            self,
            **kwargs
        ):
            """Load Events  # noqa: E501

            Returns a log of delivery events filtered by specified parameters. Required Access Level: ViewReports  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.events_get(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                event_types ([EventType]): Types of Events to return. [optional]
                _from (datetime, none_type): Starting date for search in YYYY-MM-DDThh:mm:ss format.. [optional]
                to (datetime, none_type): Ending date for search in YYYY-MM-DDThh:mm:ss format.. [optional]
                order_by (dict): [optional]
                limit (int): How many items to load. Maximum for this request is 1000 items. [optional]
                offset (int): How many items should be returned ahead.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [RecipientEvent]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.events_get = _Endpoint(
            settings={
                'response_type': ([RecipientEvent],),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/events',
                'operation_id': 'events_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_types',
                    '_from',
                    'to',
                    'order_by',
                    'limit',
                    'offset',
                ],
                'required': [],
                'nullable': [
                    '_from',
                    'to',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_types':
                        ([EventType],),
                    '_from':
                        (datetime, none_type,),
                    'to':
                        (datetime, none_type,),
                    'order_by':
                        (dict,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'event_types': 'eventTypes',
                    '_from': 'from',
                    'to': 'to',
                    'order_by': 'orderBy',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'event_types': 'query',
                    '_from': 'query',
                    'to': 'query',
                    'order_by': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                    'event_types': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__events_get
        )
