# Generated by Django 2.2.2 on 2019-07-17 04:14

import uuid

import _socket
import django.contrib.auth.models
import django.core.validators
import django.db.models.deletion
import django.db.models.manager
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_action_item.models.action_item
import edc_registration.models.managers
import edc_sites.models
import edc_utils.date
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("edc_registration", "0017_auto_20190305_0123"),
        ("edc_lab", "0019_auto_20190305_0123"),
        ("edc_action_item", "0022_auto_20190628_2136"),
        ("auth", "0011_update_proxy_permissions"),
        ("edc_visit_schedule", "0006_auto_20190706_0706"),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="DataDictionary",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("model", models.CharField(max_length=250)),
                ("model_verbose_name", models.CharField(max_length=250, null=True)),
                ("number", models.IntegerField()),
                ("prompt", models.TextField()),
                ("field_name", models.CharField(max_length=250)),
                ("field_type", models.CharField(max_length=250, null=True)),
                ("max_length", models.IntegerField(null=True)),
                ("decimal_places", models.IntegerField(null=True)),
                ("max_digits", models.IntegerField(null=True)),
                ("nullable", models.BooleanField(null=True)),
                ("default", models.CharField(max_length=250, null=True)),
                ("help_text", models.CharField(max_length=250, null=True)),
                ("active", models.BooleanField(default=False)),
            ],
            options={
                "verbose_name": "Data Dictionary Item",
                "verbose_name_plural": "Data Dictionary Items",
                "ordering": ("model", "number", "prompt"),
                "default_permissions": ("view",),
                "unique_together": {("model", "field_name")},
            },
        ),
        migrations.CreateModel(
            name="DataManagerActionItem",
            fields=[],
            options={
                "proxy": True,
                "default_permissions": ("view",),
                "indexes": [],
                "constraints": [],
            },
            bases=("edc_action_item.actionitem",),
            managers=[
                ("objects", django.db.models.manager.Manager()),
                ("on_site", edc_action_item.models.action_item.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name="DataManagerUser",
            fields=[],
            options={
                "verbose_name": "Data Manager User",
                "verbose_name_plural": "Data Manager Users",
                "proxy": True,
                "default_permissions": ("view",),
                "indexes": [],
                "constraints": [],
            },
            bases=("auth.user",),
            managers=[("objects", django.contrib.auth.models.UserManager())],
        ),
        migrations.CreateModel(
            name="QuerySubject",
            fields=[],
            options={
                "verbose_name": "Subject",
                "verbose_name_plural": "Subjects",
                "proxy": True,
                "default_permissions": ("view",),
                "indexes": [],
                "constraints": [],
            },
            bases=("edc_registration.registeredsubject",),
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
                (
                    "objects",
                    edc_registration.models.managers.RegisteredSubjectManager(),
                ),
            ],
        ),
        migrations.CreateModel(
            name="QueryUser",
            fields=[],
            options={
                "verbose_name": "Data Query User",
                "verbose_name_plural": "Data Query Users",
                "proxy": True,
                "default_permissions": ("view",),
                "indexes": [],
                "constraints": [],
            },
            bases=("auth.user",),
            managers=[("objects", django.contrib.auth.models.UserManager())],
        ),
        migrations.CreateModel(
            name="QueryVisitSchedule",
            fields=[],
            options={
                "verbose_name": "Visit Schedule",
                "verbose_name_plural": "Visit Schedule",
                "proxy": True,
                "default_permissions": ("view",),
                "indexes": [],
                "constraints": [],
            },
            bases=("edc_visit_schedule.visitschedule",),
        ),
        migrations.CreateModel(
            name="RequisitionPanel",
            fields=[],
            options={
                "verbose_name": "Requisition Panel",
                "verbose_name_plural": "Requisition Panels",
                "proxy": True,
                "default_permissions": ("view",),
                "indexes": [],
                "constraints": [],
            },
            bases=("edc_lab.panel",),
        ),
        migrations.CreateModel(
            name="HistoricalQueryRule",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                ("title", models.CharField(db_index=True, max_length=150)),
                (
                    "query_text",
                    models.TextField(
                        blank=True,
                        help_text="Generic query text for auto-generated queries.",
                        null=True,
                    ),
                ),
                (
                    "reference_model",
                    models.CharField(editable=False, max_length=150, null=True),
                ),
                (
                    "reference_date",
                    models.CharField(
                        choices=[
                            ("report_datetime", "Report datetime (visit report)"),
                            ("drawn_datetime", "Specimen draw date (requisition)"),
                        ],
                        default="report_datetime",
                        editable=False,
                        max_length=25,
                    ),
                ),
                ("timing", models.IntegerField(default=48, verbose_name="Timing")),
                (
                    "timing_units",
                    models.CharField(
                        choices=[
                            ("hours", "Hours"),
                            ("days", "Days"),
                            ("weeks", "Weeks"),
                            ("months", "Months"),
                        ],
                        default="hours",
                        max_length=25,
                        verbose_name="Units",
                    ),
                ),
                (
                    "query_priority",
                    models.CharField(
                        choices=[("high", "High"), ("NORMAL", "Normal")],
                        default="NORMAL",
                        max_length=25,
                        verbose_name="Priority",
                    ),
                ),
                (
                    "rule_handler_name",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("default", "Default"),
                            (
                                "lumbar_puncture_q13",
                                "Lumbar Puncture (Q13, 15, 21, 23, 24)",
                            ),
                        ],
                        default="default",
                        max_length=150,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.CharField(db_index=True, default=uuid.uuid4, max_length=36),
                ),
                ("comment", models.TextField(blank=True, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "requisition_panel",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Requisition will be expected on day of visit.",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_data_manager.RequisitionPanel",
                        verbose_name="Are responses linked to a requisition? If so, which",
                    ),
                ),
                (
                    "sender",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_data_manager.DataManagerUser",
                        verbose_name="Query raised by",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Query Rule",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDataQuery",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow, verbose_name="Query date"
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                ("title", models.CharField(blank=True, max_length=150, null=True)),
                (
                    "query_priority",
                    models.CharField(
                        choices=[("high", "High"), ("NORMAL", "Normal")],
                        default="NORMAL",
                        max_length=25,
                        verbose_name="Priority",
                    ),
                ),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        default=0,
                        help_text="Defaults to '0'. For example, when combined with the visit code `1000` would make `1000.0`.",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(25),
                        ],
                        verbose_name="Visit code sequence",
                    ),
                ),
                (
                    "timepoint",
                    models.DecimalField(decimal_places=1, max_digits=6, null=True),
                ),
                (
                    "query_text",
                    models.TextField(help_text="Describe the query in detail."),
                ),
                (
                    "site_resolved_datetime",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="Site resolved on"
                    ),
                ),
                ("site_response_text", models.TextField(blank=True, null=True)),
                (
                    "site_response_status",
                    models.CharField(
                        choices=[
                            ("New", "New"),
                            ("open", "Open"),
                            ("feedback", "Feedback"),
                            ("resolved", "Resolved"),
                        ],
                        default="New",
                        max_length=25,
                        verbose_name="Site status",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("open", "Open"),
                            ("resolved", "Resolved"),
                            ("resolved_with_action", "Resolved, with plan of action"),
                        ],
                        default="open",
                        max_length=25,
                        verbose_name="TCC status",
                    ),
                ),
                (
                    "resolved_datetime",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="TCC resolved on"
                    ),
                ),
                (
                    "plan_of_action",
                    models.TextField(
                        blank=True,
                        help_text="If required, provide a plan of action",
                        null=True,
                    ),
                ),
                (
                    "locked",
                    models.BooleanField(
                        default=False,
                        help_text="If locked, this query will NEVER be reopened.",
                    ),
                ),
                (
                    "rule_generated",
                    models.BooleanField(
                        default=False,
                        help_text="This query was auto-generated by a query rule.",
                    ),
                ),
                (
                    "rule_reference",
                    models.CharField(
                        default=uuid.uuid4,
                        max_length=150,
                        null=True,
                        verbose_name="Query rule reference",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "registered_subject",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_data_manager.QuerySubject",
                        verbose_name="Subject Identifier",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "requisition_panel",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Requisition will be expected on day of visit.",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_data_manager.RequisitionPanel",
                        verbose_name="Are responses linked to a requisition? If so, which",
                    ),
                ),
                (
                    "sender",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Select a name from the list",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_data_manager.DataManagerUser",
                        verbose_name="Query raised by",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "tcc_user",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="select a name from the list",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_data_manager.DataManagerUser",
                        verbose_name="TCC resolved by",
                    ),
                ),
                (
                    "visit_schedule",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_data_manager.QueryVisitSchedule",
                        verbose_name="Visit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Data Query",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDataDictionary",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("model", models.CharField(max_length=250)),
                ("model_verbose_name", models.CharField(max_length=250, null=True)),
                ("number", models.IntegerField()),
                ("prompt", models.TextField()),
                ("field_name", models.CharField(max_length=250)),
                ("field_type", models.CharField(max_length=250, null=True)),
                ("max_length", models.IntegerField(null=True)),
                ("decimal_places", models.IntegerField(null=True)),
                ("max_digits", models.IntegerField(null=True)),
                ("nullable", models.BooleanField(null=True)),
                ("default", models.CharField(max_length=250, null=True)),
                ("help_text", models.CharField(max_length=250, null=True)),
                ("active", models.BooleanField(default=False)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Data Dictionary Item",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="DataQuery",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow, verbose_name="Query date"
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                ("title", models.CharField(blank=True, max_length=150, null=True)),
                (
                    "query_priority",
                    models.CharField(
                        choices=[("high", "High"), ("NORMAL", "Normal")],
                        default="NORMAL",
                        max_length=25,
                        verbose_name="Priority",
                    ),
                ),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        default=0,
                        help_text="Defaults to '0'. For example, when combined with the visit code `1000` would make `1000.0`.",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(25),
                        ],
                        verbose_name="Visit code sequence",
                    ),
                ),
                (
                    "timepoint",
                    models.DecimalField(decimal_places=1, max_digits=6, null=True),
                ),
                (
                    "query_text",
                    models.TextField(help_text="Describe the query in detail."),
                ),
                (
                    "site_resolved_datetime",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="Site resolved on"
                    ),
                ),
                ("site_response_text", models.TextField(blank=True, null=True)),
                (
                    "site_response_status",
                    models.CharField(
                        choices=[
                            ("New", "New"),
                            ("open", "Open"),
                            ("feedback", "Feedback"),
                            ("resolved", "Resolved"),
                        ],
                        default="New",
                        max_length=25,
                        verbose_name="Site status",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("open", "Open"),
                            ("resolved", "Resolved"),
                            ("resolved_with_action", "Resolved, with plan of action"),
                        ],
                        default="open",
                        max_length=25,
                        verbose_name="TCC status",
                    ),
                ),
                (
                    "resolved_datetime",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="TCC resolved on"
                    ),
                ),
                (
                    "plan_of_action",
                    models.TextField(
                        blank=True,
                        help_text="If required, provide a plan of action",
                        null=True,
                    ),
                ),
                (
                    "locked",
                    models.BooleanField(
                        default=False,
                        help_text="If locked, this query will NEVER be reopened.",
                    ),
                ),
                (
                    "rule_generated",
                    models.BooleanField(
                        default=False,
                        help_text="This query was auto-generated by a query rule.",
                    ),
                ),
                (
                    "rule_reference",
                    models.CharField(
                        default=uuid.uuid4,
                        max_length=150,
                        null=True,
                        verbose_name="Query rule reference",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "data_dictionaries",
                    models.ManyToManyField(
                        blank=True,
                        help_text="select all that apply",
                        to="edc_data_manager.DataDictionary",
                        verbose_name="CRF question(s)",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "recipients",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Select any additional recipients. Users in the `Site Data Manager` group are automatically included.",
                        related_name="_dataquery_recipients_+",
                        to="edc_data_manager.QueryUser",
                        verbose_name="Sent to",
                    ),
                ),
                (
                    "registered_subject",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_data_manager.QuerySubject",
                        verbose_name="Subject Identifier",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "requisition_panel",
                    models.ForeignKey(
                        blank=True,
                        help_text="Requisition will be expected on day of visit.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_data_manager.RequisitionPanel",
                        verbose_name="Are responses linked to a requisition? If so, which",
                    ),
                ),
                (
                    "sender",
                    models.ForeignKey(
                        help_text="Select a name from the list",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_data_manager.DataManagerUser",
                        verbose_name="Query raised by",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "tcc_user",
                    models.ForeignKey(
                        blank=True,
                        help_text="select a name from the list",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="tcc_user",
                        to="edc_data_manager.DataManagerUser",
                        verbose_name="TCC resolved by",
                    ),
                ),
                (
                    "visit_schedule",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_data_manager.QueryVisitSchedule",
                        verbose_name="Visit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Data Query",
                "verbose_name_plural": "Data Queries",
            },
            managers=[("on_site", edc_sites.models.CurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="CrfDataDictionary",
            fields=[],
            options={
                "proxy": True,
                "default_permissions": ("view",),
                "indexes": [],
                "constraints": [],
            },
            bases=("edc_data_manager.datadictionary",),
        ),
        migrations.CreateModel(
            name="RequisitionDataDictionary",
            fields=[],
            options={
                "proxy": True,
                "default_permissions": ("view",),
                "indexes": [],
                "constraints": [],
            },
            bases=("edc_data_manager.datadictionary",),
        ),
        migrations.CreateModel(
            name="VisitDataDictionary",
            fields=[],
            options={
                "proxy": True,
                "default_permissions": ("view",),
                "indexes": [],
                "constraints": [],
            },
            bases=("edc_data_manager.datadictionary",),
        ),
        migrations.CreateModel(
            name="QueryRule",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                ("title", models.CharField(max_length=150, unique=True)),
                (
                    "query_text",
                    models.TextField(
                        blank=True,
                        help_text="Generic query text for auto-generated queries.",
                        null=True,
                    ),
                ),
                (
                    "reference_model",
                    models.CharField(editable=False, max_length=150, null=True),
                ),
                (
                    "reference_date",
                    models.CharField(
                        choices=[
                            ("report_datetime", "Report datetime (visit report)"),
                            ("drawn_datetime", "Specimen draw date (requisition)"),
                        ],
                        default="report_datetime",
                        editable=False,
                        max_length=25,
                    ),
                ),
                ("timing", models.IntegerField(default=48, verbose_name="Timing")),
                (
                    "timing_units",
                    models.CharField(
                        choices=[
                            ("hours", "Hours"),
                            ("days", "Days"),
                            ("weeks", "Weeks"),
                            ("months", "Months"),
                        ],
                        default="hours",
                        max_length=25,
                        verbose_name="Units",
                    ),
                ),
                (
                    "query_priority",
                    models.CharField(
                        choices=[("high", "High"), ("NORMAL", "Normal")],
                        default="NORMAL",
                        max_length=25,
                        verbose_name="Priority",
                    ),
                ),
                (
                    "rule_handler_name",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("default", "Default"),
                            (
                                "lumbar_puncture_q13",
                                "Lumbar Puncture (Q13, 15, 21, 23, 24)",
                            ),
                        ],
                        default="default",
                        max_length=150,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.CharField(default=uuid.uuid4, max_length=36, unique=True),
                ),
                ("comment", models.TextField(blank=True, null=True)),
                (
                    "recipients",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Select any additional recipients. Users in the `Site Data Manager` group are automatically included.",
                        related_name="_queryrule_recipients_+",
                        to="edc_data_manager.QueryUser",
                        verbose_name="Send to",
                    ),
                ),
                (
                    "requisition_panel",
                    models.ForeignKey(
                        blank=True,
                        help_text="Requisition will be expected on day of visit.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_data_manager.RequisitionPanel",
                        verbose_name="Are responses linked to a requisition? If so, which",
                    ),
                ),
                (
                    "sender",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_data_manager.DataManagerUser",
                        verbose_name="Query raised by",
                    ),
                ),
                (
                    "sites",
                    models.ManyToManyField(
                        help_text="Leave blank to apply to all.", to="sites.Site"
                    ),
                ),
                (
                    "visit_schedule",
                    models.ManyToManyField(
                        blank=True,
                        help_text="select all that apply",
                        related_name="_queryrule_visit_schedule_+",
                        to="edc_data_manager.QueryVisitSchedule",
                        verbose_name="Visit",
                    ),
                ),
                (
                    "visit_schedule_exclude",
                    models.ManyToManyField(
                        blank=True,
                        help_text="select all that apply",
                        related_name="_queryrule_visit_schedule_exclude_+",
                        to="edc_data_manager.QueryVisitSchedule",
                        verbose_name="Visit (exclude)",
                    ),
                ),
                (
                    "data_dictionaries",
                    models.ManyToManyField(
                        blank=True,
                        help_text="select all that apply",
                        related_name="_queryrule_data_dictionaries_+",
                        to="edc_data_manager.CrfDataDictionary",
                        verbose_name="Question(s)",
                    ),
                ),
            ],
            options={
                "verbose_name": "Query Rule",
                "verbose_name_plural": "Query Rules",
                "ordering": ("title",),
            },
        ),
        migrations.AddIndex(
            model_name="dataquery",
            index=models.Index(
                fields=[
                    "subject_identifier",
                    "action_identifier",
                    "title",
                    "rule_reference",
                    "registered_subject",
                    "visit_schedule",
                ],
                name="edc_data_ma_subject_875fa1_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="queryrule",
            index=models.Index(
                fields=["title", "active"], name="edc_data_ma_title_c3118f_idx"
            ),
        ),
    ]
