import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudMongoClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The friendly name of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_cluster#display_name DataIonoscloudMongoCluster#display_name}
    */
    readonly displayName?: string;
    /**
    * The id of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_cluster#id DataIonoscloudMongoCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_cluster#timeouts DataIonoscloudMongoCluster#timeouts}
    */
    readonly timeouts?: DataIonoscloudMongoClusterTimeouts;
}
export interface DataIonoscloudMongoClusterConnections {
}
export declare function dataIonoscloudMongoClusterConnectionsToTerraform(struct?: DataIonoscloudMongoClusterConnections): any;
export declare class DataIonoscloudMongoClusterConnectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudMongoClusterConnections | undefined;
    set internalValue(value: DataIonoscloudMongoClusterConnections | undefined);
    get cidrList(): string[];
    get datacenterId(): string;
    get lanId(): string;
}
export declare class DataIonoscloudMongoClusterConnectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudMongoClusterConnectionsOutputReference;
}
export interface DataIonoscloudMongoClusterCredentials {
}
export declare function dataIonoscloudMongoClusterCredentialsToTerraform(struct?: DataIonoscloudMongoClusterCredentials): any;
export declare class DataIonoscloudMongoClusterCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudMongoClusterCredentials | undefined;
    set internalValue(value: DataIonoscloudMongoClusterCredentials | undefined);
    get password(): string;
    get username(): string;
}
export declare class DataIonoscloudMongoClusterCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudMongoClusterCredentialsOutputReference;
}
export interface DataIonoscloudMongoClusterMaintenanceWindow {
}
export declare function dataIonoscloudMongoClusterMaintenanceWindowToTerraform(struct?: DataIonoscloudMongoClusterMaintenanceWindow): any;
export declare class DataIonoscloudMongoClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudMongoClusterMaintenanceWindow | undefined;
    set internalValue(value: DataIonoscloudMongoClusterMaintenanceWindow | undefined);
    get dayOfTheWeek(): string;
    get time(): string;
}
export declare class DataIonoscloudMongoClusterMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudMongoClusterMaintenanceWindowOutputReference;
}
export interface DataIonoscloudMongoClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_cluster#create DataIonoscloudMongoCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_cluster#default DataIonoscloudMongoCluster#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_cluster#delete DataIonoscloudMongoCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_cluster#update DataIonoscloudMongoCluster#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudMongoClusterTimeoutsToTerraform(struct?: DataIonoscloudMongoClusterTimeoutsOutputReference | DataIonoscloudMongoClusterTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudMongoClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudMongoClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudMongoClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_cluster ionoscloud_mongo_cluster}
*/
export declare class DataIonoscloudMongoCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_mongo_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/mongo_cluster ionoscloud_mongo_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudMongoClusterConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudMongoClusterConfig);
    get connectionString(): string;
    private _connections;
    get connections(): DataIonoscloudMongoClusterConnectionsList;
    private _credentials;
    get credentials(): DataIonoscloudMongoClusterCredentialsList;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instances(): number;
    get location(): string;
    private _maintenanceWindow;
    get maintenanceWindow(): DataIonoscloudMongoClusterMaintenanceWindowList;
    get mongodbVersion(): string;
    get templateId(): string;
    private _timeouts;
    get timeouts(): DataIonoscloudMongoClusterTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudMongoClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudMongoClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
