import logging
from django.core.management.base import BaseCommand
import otree.bots.browser
from otree.common import get_redis_conn

logger = logging.getLogger('otree.botworker')


class Command(BaseCommand):
    help = "oTree: Run the worker for browser bots."

    def handle(self, *args, **options):
        redis_conn = get_redis_conn()
        otree.bots.browser.redis_flush_bots(redis_conn)
        worker = otree.bots.browser.BotAndLiveWorker(redis_conn)
        worker = otree.bots.browser.BotAndLiveWorker(redis_conn)

        worker.redis_listen()
