from typing import Dict, List

CHARACTERS: Dict[str, List[str]] = {
    "A": [
        "       ",
        " _____ ",
        "|  _  |",
        "|     |",
        "|__|__|",
        "       ",
    ],
    "a": [
        "     ",
        "     ",
        " ___ ",
        "| .'|",
        "|__,|",
        "     ",
    ],
    "B": [
        "       ",
        " _____ ",
        "| __  |",
        "| __ -|",
        "|_____|",
        "       ",
    ],
    "b": [
        "     ",
        " _   ",
        "| |_ ",
        "| . |",
        "|___|",
        "     ",
    ],
    "C": [
        "       ",
        " _____ ",
        "|     |",
        "|   --|",
        "|_____|",
        "       ",
    ],
    "c": [
        "     ",
        "     ",       
        " ___ ",
        "|  _|",
        "|___|",
        "     ",
    ],
    "D": [
        "       ",
        " ____  ",
        "|    \ ",
        "|  |  |",
        "|____/ ",
        "       ",
    ],
    "d": [
        "     ",
        "   _ ",
        " _| |",
        "| . |",
        "|___|",
        "     ",
    ],
    "E": [
        "       ",
        " _____ ",
        "|   __|",
        "|   __|",
        "|_____|",
        "       ",
    ],
    "e": [
        "     ",
        "     ",
        " ___ ",
        "| -_|",
        "|___|",
        "     ",
    ],
    "F": [
        "       ",
        " _____ ",
        "|   __|",
        "|   __|",
        "|__|   ",
        "       ",
    ],
    "f": [
        "     ",
        " ___ ",
        "|  _|",
        "|  _|",
        "|_|  ",
        "     ",
    ],
    "G": [
        "       ",
        " _____ ",
        "|   __|",
        "|  |  |",
        "|_____|",
        "       ",
    ],
    "g": [
        "     ",
        "     ",
        " ___ ",
        "| . |",
        "|_  |",
        "|___|",
    ],
    "H": [
        "       ",
        " _____ ",
        "|  |  |",
        "|     |",
        "|__|__|",
        "       ",
    ],
    "h": [
        "     ",
        " _   ",
        "| |_ ",
        "|   |",
        "|_|_|",
        "     ",
    ],
    "I": [
        "       ",
        " _____ ",
        "|     |",
        "|-   -|",
        "|_____|",
        "       ",
    ],
    "i": [
        "   ",
        " _ ",
        "|_|",
        "| |",
        "|_|",
        "   ",
    ],
    "J": [
        "       ",
        "    __ ",
        " __|  |",
        "|  |  |",
        "|_____|",
        "       ",
    ],
    "j": [
        "     ",
        "   _ ",
        "  |_|",
        "  | |",
        " _| |",
        "|___|",
    ],
    "K": [
        "       ",
        " _____ ",
        "|  |  |",
        "|    -|",
        "|__|__|",
        "       ",
    ],
    "k": [
        "     ",
        " _   ",
        "| |_ ",
        "| '_|",
        "|_,_|",
        "     ",
    ],
    "L": [
        "       ",
        " __    ",
        "|  |   ",
        "|  |__ ",
        "|_____|",
        "       ",
    ],
    "l": [
        "   ",
        " _ ",
        "| |",
        "| |",
        "|_|",
        "   ",
    ],
    "M": [
        "       ",
        " _____ ",
        "|     |",
        "| | | |",
        "|_|_|_|",
        "       ",
    ],
    "m": [
        "       ",
        "       ",
        " _____ ",
        "|     |",
        "|_|_|_|",
        "       ",
    ],
    "N": [
        "       ",
        " _____ ",
        "|   | |",
        "| | | |",
        "|_|___|",
        "       ",
    ],
    "n": [
        "     ",
        "     ",
        " ___ ",
        "|   |",
        "|_|_|",
        "     ",
    ],
    "O": [
        "       ",
        " _____ ",
        "|     |",
        "|  |  |",
        "|_____|",
        "       ",
    ],
    "o": [
        "     ",
        "     ",
        " ___ ",
        "| . |",
        "|___|",
        "     ",
    ],
    "P": [
        "       ",
        " _____ ",
        "|  _  |",
        "|   __|",
        "|__|   ",
        "       ",
    ],
    "p": [
        "     ",
        "     ",
        " ___ ",
        "| . |",
        "|  _|",
        "|_|  ",
    ],
    "Q": [
        "       ",
        " _____ ",
        "|     |",
        "|  |  |",
        "|__  _|",
        "   |__|",
    ],
    "q": [
        "     ",
        "     ",
        " ___ ",
        "| . |",
        "|_  |",
        "  |_|",
    ],
    "R": [
        "       ",
        " _____ ",
        "| __  |",
        "|    -|",
        "|__|__|",
        "       ",
    ],
    "r": [
        "     ",
        "     ",
        " ___ ",
        "|  _|",
        "|_|  ",
        "     ",
    ],
    "S": [
        "       ",
        " _____ ",
        "|   __|",
        "|__   |",
        "|_____|",
        "       ",
    ],
    "s": [
        "     ",
        "     ",
        " ___ ",
        "|_ -|",
        "|___|",
        "     ",
    ],
    "T": [
        "       ",
        " _____ ",
        "|_   _|",
        "  | |  ",
        "  |_|  ",
        "       ",
    ],
    "t": [
        "     ",
        " _   ",
        "| |_ ",
        "|  _|",
        "|_|  ",
        "     ",
    ],
    "U": [
        "       ",
        " _____ ",
        "|  |  |",
        "|  |  |",
        "|_____|",
        "       ",
    ],
    "u": [
        "     ",
        "     ",
        " _ _ ",
        "| | |",
        "|___|",
        "     ",
    ],
    "V": [
        "       ",
        " _____ ",
        "|  |  |",
        "|  |  |",
        " \___/ ",
        "       ",
    ],
    "v": [
        "     ",
        "     ",    
        " _ _ ",
        "| | |",
        " \_/ ",
        "     ",
    ],
    "W": [
        "       ",
        " _ _ _ ",
        "| | | |",
        "| | | |",
        "|_____|",
        "       ",
    ],
    "w": [
        "       ",
        "       ",
        " _ _ _ ",
        "| | | |",
        "|_____|",
        "       ",
    ],
    "X": [
        "       ",
        " __ __ ",
        "|  |  |",
        "|-   -|",
        "|__|__|",
        "       ",
    ],
    "x": [
        "     ",
        "     ",
        " _ _ ",
        "|_'_|",
        "|_,_|",
        "     ",
    ],
    "Y": [
        "       ",
        " __ __ ",
        "|  |  |",
        "|_   _|",
        "  |_|  ",
        "       ",
    ],
    "y": [
        "     ",
        "     ",
        " _ _ ",
        "| | |",
        "|_  |",
        "|___|",
    ],
    "Z": [
        "       ",
        " _____ ",
        "|__   |",
        "|   __|",
        "|_____|",
        "       ",
    ],
    "z": [
        "     ",
        "     ",
        " ___ ",
        "|- _|",
        "|___|",
        "     ",
    ],
    "0": [
        "     ",
        " ___ ",
        "|   |",
        "| | |",
        "|___|",
        "     ",
    ],
    "1": [
        "       ",
        " ___   ",
        "|_  |  ",
        " _| |_ ",
        "|_____|",
        "       ",
    ],
    "2": [
        "     ",
        " ___ ",
        "|_  |",
        "|  _|",
        "|___|",
        "     ",
    ],
    "3": [
        "     ",
        " ___ ",
        "|_  |",
        "|_  |",
        "|___|",
        "     ",
    ],
    "4": [
        "     ",
        " ___ ",
        "| | |",
        "|_  |",
        "  |_|",
        "     ",
    ],
    "5": [
        "     ",
        " ___ ",
        "|  _|",
        "|_  |",
        "|___|",
        "     ",
    ],
    "6": [
        "     ",
        " ___ ",
        "|  _|",
        "| . |",
        "|___|",
        "     ",
    ],
    "7": [
        "     ",
        " ___ ",
        "|_  |",
        "  | |",
        "  |_|",
        "     ",
    ],
    "8": [
        "     ",
        " ___ ",
        "| . |",
        "| . |",
        "|___|",
        "     ",
    ],
    "9": [
        "     ",
        " ___ ",
        "| . |",
        "|_  |",
        "|___|",
        "     ",
    ],
    " ": [
        "  ",
        "  ",
        "  ",
        "  ",
        "  ",
        "  ",
    ],
    "!": [
        " __ ",
        "|  |",
        "|  |",
        "|__|",
        "|__|",
        "    ",
    ],
    "\"": [
        " _ _ ",
        "| | |",
        "|_|_|",
        "     ",
        "     ",
        "     ",
    ],
    "'": [
        " _ ",
        "| |",
        "|_|",
        "   ",
        "   ",
        "   ",
    ],
    "#": [
        "   _ _   ",
        " _| | |_ ",
        "|_     _|",
        "|_     _|",
        "  |_|_|  ",
        "         ",
    ],
    "$": [
        "   _   ",
        " _| |_ ",
        "|   __|",
        "|__   |",
        "|_   _|",
        "  |_|  ",
    ],
    "%": [
        "       ",
        " __ __ ",
        "|__|  |",
        "|   __|",
        "|__|__|",
        "       ",
    ],
    "&": [
        "   _   ",
        " _| |_ ",
        "|   __|",
        "|   __|",
        "|_   _|",
        "  |_|  ",
    ],
    "/": [
        "     ",
        "   _ ",
        "  / |",
        " / / ",
        "|_/  ",
        "     ",
    ],
    "=": [
        "       ",
        "       ",
        " _____ ",
        "|_____|",
        "|_____|",
        "       ",
    ],
    "?": [
        " _____ ",
        "|___  |",
        "  |  _|",
        "  |_|  ",
        "  |_|  ",
        "       ",
    ],
    "_": [
        "       ",
        "       ",
        "       ",
        "       ",
        " _____ ",
        "|_____|",
    ],
    "-": [
        "     ",
        "     ",
        " ___ ",
        "|___|",
        "     ",
        "     ",
    ],
    ".": [
        "   ",
        "   ",
        "   ",
        " _ ",
        "|_|",
        "   ",
    ],
    ",": [
        "   ",
        "   ",
        "   ",
        " _ ",
        "| |",
        "|_|",
    ],
    ";": [
        "   ",
        " _ ",
        "|_|",
        " _ ",
        "| |",
        "|_|",
    ],
    ":": [
        "   ",
        " _ ",
        "|_|",
        " _ ",
        "|_|",
        "   ",
    ],
    "+": [
        "       ",
        "   _   ",
        " _| |_ ",
        "|_   _|",
        "  |_|  ",
        "       ",
    ],
    "*": [
        "       ",
        " _____ ",
        "| | | |",
        "|-   -|",
        "|_|_|_|",
        "       ",
    ],
    "(": [
        "   _ ",
        " _|_|",
        "| |  ",
        "| |  ",
        "|_|_ ",
        "  |_|",
    ],
    ")": [
        " _   ",
        "|_|_ ",
        "  | |",
        "  | |",
        " _|_|",
        "|_|  ",
    ],
    "[": [
        " ___ ",
        "|  _|",
        "| |  ",
        "| |  ",
        "| |_ ",
        "|___|",
    ],
    "]": [
        " ___ ",
        "|_  |",
        "  | |",
        "  | |",
        " _| |",
        "|___|",
    ],
    "{": [
        "   ___ ",
        "  |  _|",
        " _| |  ",
        "|_  |  ",
        "  | |_ ",
        "  |___|",
    ],
    "}": [
        " ___   ",
        "|_  |  ",
        "  | |_ ",
        "  |  _|",
        " _| |  ",
        "|___|  ",
    ],
    "<": [
        "   __",
        "  / /",
        " / / ",
        "< <  ",
        " \ \ ",
        "  \_\\",
    ],
    ">": [
        "__   ",
        "\ \  ",
        " \ \ ",
        "  > >",
        " / / ",
        "/_/  ",
    ],
    "@": [
        "       ",
        " _____ ",
        "|  __ |",
        "| |___|",
        "|_____|",
        "       ",
    ],
    "^": [
        " _____ ",
        "|  _  |",
        "|_| |_|",
        "       ",
        "       ",
        "       ",
    ],
    "~": [
        " _____ ",
        "|   | |",
        "|_|___|",
        "       ",
        "       ",
        "       ",
    ],
}

MATRIX_PANEL: Dict[str, List[List[int]]] = {
    "a": [
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 1, 1, 1, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        ],
    "b": [
        [1, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 1, 1, 1, 0],
    ],
    "c": [
        [0, 1, 1, 1, 1],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [0, 1, 1, 1, 1],
    ],
    "d": [
        [1, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 1, 1, 1, 0],
    ],
    "e": [
        [1, 1, 1, 1, 1],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 1, 1, 1, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 1, 1, 1, 1],
    ],
    "f": [
        [1, 1, 1, 1, 1],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 1, 1, 1, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
    ],
    "g": [
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 1, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 1, 1, 0],
    ],
    "h": [
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 1, 1, 1, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
    ],
    "i": [
        [1, 1, 1, 1, 1],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [1, 1, 1, 1, 1],
    ],
    "j": [
        [1, 1, 1, 1, 1],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [1, 1, 1, 0, 0],
    ],
    "k": [
        [1, 0, 0, 0, 1],
        [1, 0, 0, 1, 0],
        [1, 0, 1, 0, 0],
        [1, 1, 0, 0, 0],
        [1, 0, 1, 0, 0],
        [1, 0, 0, 1, 0],
        [1, 0, 0, 0, 1],
    ],
    "l": [
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 1, 1, 1, 1],
    ],
    "m": [
        [1, 0, 0, 0, 1],
        [1, 1, 0, 1, 1],
        [1, 0, 1, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
    ],
    "n": [
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 1, 0, 0, 1],
        [1, 0, 1, 0, 1],
        [1, 0, 0, 1, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
    ],
    "o": [
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 1, 1, 0],
    ],
    "p": [
        [1, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 1, 1, 1, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
    ],
    "q": [
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 1, 0, 1],
        [1, 0, 0, 1, 1],
        [0, 1, 1, 1, 1],
    ],
    "r": [
        [1, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
    ],
    "s": [
        [0, 1, 1, 1, 1],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [0, 1, 1, 1, 0],
        [0, 0, 0, 0, 1],
        [0, 0, 0, 0, 1],
        [1, 1, 1, 1, 0],
    ],
    "t": [
        [1, 1, 1, 1, 1],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
    ],
    "u": [
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 1, 1, 0],
    ],
    "v": [
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 0, 1, 0],
        [0, 0, 1, 0, 0],
    ],
    "w": [
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 1, 0, 1],
        [1, 1, 0, 1, 1],
        [1, 0, 0, 0, 1],
    ],
    "x": [
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 0, 1, 0],
        [0, 0, 1, 0, 0],
        [0, 1, 0, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
    ],
    "y": [
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 0, 1, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
    ],
    "z": [
        [1, 1, 1, 1, 1],
        [0, 0, 0, 0, 1],
        [0, 0, 0, 1, 0],
        [0, 0, 1, 0, 0],
        [0, 1, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 1, 1, 1, 1],
    ],
    " ": [
        [0, 0, 0, 0, 0],
        [0, 0, 0, 0, 0],
        [0, 0, 0, 0, 0],
        [0, 0, 0, 0, 0],
        [0, 0, 0, 0, 0],
        [0, 0, 0, 0, 0],
        [0, 0, 0, 0, 0],
    ],
    "0": [
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 1, 1],
        [1, 0, 1, 0, 1],
        [1, 1, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 1, 1, 0],
    ],
    "1": [
        [0, 0, 1, 0, 0],
        [0, 1, 1, 0, 0],
        [1, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [1, 1, 1, 1, 1],
    ],
    "2": [
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [0, 0, 0, 0, 1],
        [0, 0, 0, 1, 0],
        [0, 0, 1, 0, 0],
        [0, 1, 0, 0, 0],
        [1, 1, 1, 1, 1],
    ],
    "3": [
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [0, 0, 0, 0, 1],
        [0, 0, 1, 1, 0],
        [0, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 1, 1, 0],
    ],
    "4": [
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 1, 1, 1, 1],
        [0, 0, 0, 0, 1],
        [0, 0, 0, 0, 1],
        [0, 0, 0, 0, 1],
    ],
    "5": [
        [1, 1, 1, 1, 1],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0],
        [1, 1, 1, 1, 0],
        [0, 0, 0, 0, 1],
        [0, 0, 0, 0, 1],
        [1, 1, 1, 1, 0],
    ],
    "6": [
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 0],
        [1, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 1, 1, 0],
    ],
    "7": [
        [1, 1, 1, 1, 1],
        [0, 0, 0, 0, 1],
        [0, 0, 0, 1, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 0, 0],
    ],
    "8": [
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 1, 1, 0],
    ],
    "9": [
        [0, 1, 1, 1, 0],
        [1, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 1, 1, 1],
        [0, 0, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [0, 1, 1, 1, 0],
    ],
}
