<p align="center">
  <img src="https://github.com/UlionTse/translators/blob/master/docs/translators_logo.png" width="500"/>
</p>
<p align="center">
  <a href="https://pypi.org/project/translators"><img alt="PyPI - Version" src="https://img.shields.io/pypi/v/translators.svg?color=blue"></a>
  <a href="https://anaconda.org/conda-forge/translators"><img alt="Conda - Version" src="https://img.shields.io/conda/vn/conda-forge/translators.svg?color=blue"></a>
  <a href="https://pypi.org/project/translators"><img alt="PyPI - License" src="https://img.shields.io/pypi/l/translators.svg?color=brightgreen"></a>
  <a href="https://pypi.org/project/translators"><img alt="PyPI - Python" src="https://img.shields.io/pypi/pyversions/translators.svg?color=blue"></a>
  <a href="https://pypi.org/project/translators"><img alt="PyPI - Status" src="https://img.shields.io/pypi/status/translators.svg?color=brightgreen"></a>
  <a href="https://pypi.org/project/translators"><img alt="PyPI - Wheel" src="https://img.shields.io/badge/wheel-yes-brightgreen.svg"></a>
  <a href="https://pypi.org/project/translators"><img alt="PyPI - Downloads" src="https://static.pepy.tech/personalized-badge/translators?period=total&units=international_system&left_text=downloads&left_color=grey&right_color=blue"></a>
</p>

* * *

**Translators** is a library which aims to bring **free, multiple, enjoyable** translation to individuals and students in Python. 

<details>
<summary>Supported Translation Services</summary>

| ID  | Translator                                                                        | Number of Supported Languages | Advantage                                                                                   | Service                                                                                                           | Status                          |
| --- | --------------------------------------------------------------------------------- | ----------------------------- | ------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------- | ------------------------------- |
| 1   | [MyMemory](https://mymemory.translated.net)                                       | 330                           | support the most languages in the world                                                     | [Translated](https://translatedlabs.com/welcome), Italy                                                           | stable                          |
| 2   | [Niutrans](https://niutrans.com/trans)                                            | 302                           | support the most languages in the world                                                     | [Northeastern University](http://english.neu.edu.cn/) / [Niutrans](https://github.com/NiuTrans), China            | /                               |
| 3   | [Alibaba](https://translate.alibaba.com)                                          | 221                           | support most languages, support professional field                                          | [Alibaba](https://damo.alibaba.com/about?lang=en), China                                                          | stable                          |
| 4   | [Baidu](https://fanyi.baidu.com)                                                  | 201                           | support most languages, support professional field, support classical Chinese               | [Baidu](https://ir.baidu.com/company-overview), China                                                             | stable                          |
| 5   | [Iciba](https://www.iciba.com/fy)                                                 | 187                           | support the most languages in the world                                                     | [Kingsoft](https://www.wps.com/about-us/) / [Xiaomi](https://www.mi.com/us/about/), China                         | stable                          |
| 6   | [Iflytek](https://fanyi.xfyun.cn/console/trans/text)                              | 140                           | support the most languages in the world                                                     | [Iflytek](https://www.iflytek.com/en/about-us.html), China                                                        | /                               |
| 7   | [Google](https://translate.google.com)                                            | 134                           | support more languages in the world                                                         | [Google](https://about.google/), America                                                                          | stable(offline in China inland) |
| 8   | [VolcEngine](https://translate.volcengine.com)                                    | 122                           | support more languages in the world, support professional field                             | [ByteDance](https://www.bytedance.com/en/), China                                                                 | /                               |
| 9   | [Lingvanex](https://lingvanex.com/demo)                                           | 112                           | support translation of different regions but the same language                              | [Lingvanex](https://lingvanex.com/about-us/), Cyprus                                                              | stable                          |
| 10  | [Bing](https://www.bing.com/Translator)                                           | 110                           | support more languages in the world                                                         | [Microsoft](https://www.microsoft.com/en-us/about), America                                                       | stable                          |
| 11  | [Yandex](https://translate.yandex.com)                                            | 102                           | support more languages in the world, support word to emoji                                  | [Yandex](https://yandex.com/company/), Russia                                                                     | /                               |
| 12  | [Itranslate](https://itranslate.com/webapp)                                       | 101                           | support translation of different regions but the same language, such as en-US, en-UK, en-AU | [Itranslate](https://itranslate.com/about), Austria                                                               | stable                          |
| 13  | [Sogou](https://fanyi.sogou.com/text)                                             | 61                            | support more languages in the world                                                         | [Tencent](https://www.tencent.com/en-us/about.html), China                                                        | stable                          |
| 14  | [ModernMt](https://www.modernmt.com/translate)                                    | 56                            | open-source, support more languages in the world                                            | [Modernmt](https://github.com/modernmt) / [Translated](https://translatedlabs.com/welcome), Italy                 | stable                          |
| 15  | [SysTran](https://www.systran.net/translate/)                                     | 52                            | support more languages in the world                                                         | [SysTran](https://www.systran.net/about/), France                                                                 | stable                          |
| 16  | [Apertium](https://www.apertium.org/)                                             | 45                            | open-source                                                                                 | [Apertium](https://github.com/apertium), Spain                                                                    | stable                          |
| 17  | [Reverso](https://www.reverso.net/text-translation)                               | 42                            | popular on Mac and Iphone                                                                   | [Reverso](https://www.corporate-translation.reverso.com/about-us), France                                         | stable                          |
| 18  | [CloudTranslation](https://www.cloudtranslation.com/#/translate)                  | 28                            | support main languages                                                                      | [Xiamen University](http://nlp.xmu.edu.cn/) / [CloudTranslation](https://www.cloudtranslation.com/#/about), China | stable                          |
| 19  | [Deepl](https://www.deepl.com/translator)                                         | 27                            | high quality to translate but response slowly                                               | [Deepl](https://jobs.deepl.com/l/en), Germany                                                                     | stable                          |
| 20  | [QQTranSmart](https://transmart.qq.com)                                           | 22                            | support main languages                                                                      | [Tencent](https://www.tencent.com/en-us/about.html), China                                                        | stable                          |
| 21  | [TranslateCom](https://www.translate.com/machine-translation)                     | 21                            | good at English translation                                                                 | [TranslateCom](https://www.translate.com/about-us), America                                                       | stable                          |
| 22  | [Tilde](https://translate.tilde.com/)                                             | 21                            | good at lv, de, fr translation                                                              | [Tilde](https://tilde.com/about), Latvia                                                                          | /                               |
| 23  | [QQFanyi](https://fanyi.qq.com)                                                   | 17                            | support main languages                                                                      | [Tencent](https://www.tencent.com/en-us/about.html), China                                                        | stable                          |
| 24  | [Argos](https://translate.argosopentech.com)                                      | 17                            | open-source                                                                                 | [Argos](https://github.com/argosopentech) / [Libre](https://github.com/LibreTranslate), America                   | stable                          |
| 25  | [TranslateMe](https://translateme.network/)                                       | 16                            | good at English translation                                                                 | [TranslateMe](https://translateme.network/our-team/) / [Neosus](https://neosus.net/about/), Lithuania             | /                               |
| 26  | [Youdao](https://ai.youdao.com/product-fanyi-text.s)                              | 15                            | support main languages, high quality                                                        | [Netease](https://ir.netease.com/company-overview/corporate-profile), China                                       | stable                          |
| 27  | [Papago](https://papago.naver.com)                                                | 15                            | good at Korean translation                                                                  | [Naver](https://www.navercorp.com/en/naver/company), South Korea                                                  | stable                          |
| 28  | [Marai](https://miraitranslate.com/trial/)                                        | 15                            | good at Japanese translation                                                                | [MaraiTranslate](https://miraitranslate.com/en/company/), Japan                                                   | /                               |
| 29  | [Iflyrec](https://fanyi.iflyrec.com)                                              | 12                            | good at Chinese translation                                                                 | [Iflytek](https://www.iflytek.com/en/about-us.html), China                                                        | stable                          |
| 30  | [Yeekit](https://www.yeekit.com/site/translate)                                   | 10                            | support main languages                                                                      | [CTC](https://www.ctpc.com.cn/cms/enAboutUs.htm), China                                                           | /                               |
| 31  | [LanguageWire](https://www.languagewire.com/en/technology/languagewire-translate) | 8                             | good at English translation                                                                 | [LanguageWire](https://www.languagewire.com/about-us), Denmark                                                    | stable                          |
| 32  | [Caiyun](https://fanyi.caiyunapp.com)                                             | 7                             | high quality to translate but response slowly, support professional field                   | [ColorfulClouds](http://caiyunapp.com/jobs/), China                                                               | stable                          |
| 33  | [Elia](https://elia.eus/translator)                                               | 6                             | good at Basque translation                                                                  | [Elhuyar](https://www.elhuyar.eus/eu/nor-gara), Spain                                                             | stable                          |
| 34  | [Judic](https://judic.io/en/translate)                                            | 4                             | good at European translation                                                                | [CrossLang](https://crosslang.com/about-us/), Belgium                                                             | stable                          |
| 35  | [Mglip](http://fy.mglip.com/pc)                                                   | 3                             | good at Mongolia translation                                                                | [Inner Mongolia University](https://www.imu.edu.cn/yw/Home.htm), China                                            | stable                          |
| 36  | [Utibet](http://mt.utibet.edu.cn/mt)                                              | 2                             | good at Tibet translation                                                                   | [Tibet University](http://www.utibet.edu.cn/), China                                                              | stable                          |

</details>

<details>
<summary>Installation</summary>

```sh
# PYPI
pip install --upgrade translators

# Conda
conda install -c conda-forge translators

# Source
git clone https://github.com/UlionTse/translators.git
cd translators
python setup.py install
```

</details>

<details>
<summary>Getting Started</summary>

```python
import translators as ts

q_text = '季姬寂，集鸡，鸡即棘鸡。棘鸡饥叽，季姬及箕稷济鸡。'
q_html = '''<!DOCTYPE html><html><head><title>《季姬击鸡记》</title></head><body><p>还有另一篇文章《施氏食狮史》。</p></body></html>'''

### usage
_ = ts.preaccelerate_and_speedtest()  # Optional. Caching sessions in advance, which can help improve access speed.

print(ts.translators_pool)
print(ts.translate_text(q_text))
print(ts.translate_html(q_html, translator='alibaba'))

### parameters
help(ts.translate_text)

"""
translate_text(query_text: str, translator: str = 'bing', from_language: str = 'auto', to_language: str = 'en', **kwargs) -> Union[str, dict]
    :param query_text: str, must.
    :param translator: str, default 'bing'.
    :param from_language: str, default 'auto'.
    :param to_language: str, default 'en'.
    :param if_use_preacceleration: bool, default False.
    :param **kwargs:
            :param is_detail_result: bool, default False.
            :param professional_field: str, default None. Support alibaba(), baidu(), caiyun(), cloudTranslation(), elia(), sysTran(), youdao(), volcEngine() only.
            :param timeout: float, default None.
            :param proxies: dict, default None.
            :param sleep_seconds: float, default 0.
            :param update_session_after_freq: int, default 1000.
            :param update_session_after_seconds: float, default 1500.
            :param if_use_cn_host: bool, default False. Support google(), bing() only.                
            :param reset_host_url: str, default None. Support google(), argos(), yandex() only.
            :param if_check_reset_host_url: bool, default True. Support google(), yandex() only.
            :param if_ignore_empty_query: bool, default False.
            :param limit_of_length: int, default 20000.
            :param if_ignore_limit_of_length: bool, default False.
            :param if_show_time_stat: bool, default False.
            :param show_time_stat_precision: int, default 2.
            :param if_print_warning: bool, default True.
            :param lingvanex_mode: str, default 'B2C', choose from ("B2C", "B2B").
            :param myMemory_mode: str, default "web", choose from ("web", "api").
    :return: str or dict
"""
```

</details>

<details>
<summary>Supported Languages</summary>

| Language             | Language of Translator | [Google](https://translate.google.com) | [Yandex](https://translate.yandex.com) | [Bing](https://www.bing.com/Translator) | [Baidu](https://fanyi.baidu.com) | [Alibaba](https://translate.alibaba.com) | [Tencent](https://fanyi.qq.com) | [Youdao](https://fanyi.youdao.com) | [Sogou](https://fanyi.sogou.com) | [Deepl](https://www.deepl.com/translator) | [Caiyun](https://fanyi.caiyunapp.com) | [Argos](https://translate.argosopentech.com) | others... |
| -------------------- | ---------------------- | -------------------------------------- | -------------------------------------- | --------------------------------------- | -------------------------------- | ---------------------------------------- | ------------------------------- | ---------------------------------- | -------------------------------- | ----------------------------------------- | ------------------------------------- | -------------------------------------------- | --------- |
| english              | en                     | Y                                      | Y                                      | Y                                       | Y                                | Y                                        | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            | ...       |
| chinese              | zh                     | Y                                      | Y                                      | Y                                       | Y                                | Y                                        | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            |           |
| arabic               | ar                     | Y                                      | Y                                      | Y                                       | Y(ara)                           | Y                                        | Y                               | Y                                  | Y                                |                                           |                                       | Y                                            |           |
| russian              | ru                     | Y                                      | Y                                      | Y                                       | Y                                | Y                                        | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            |           |
| french               | fr                     | Y                                      | Y                                      | Y                                       | Y(fra)                           | Y                                        | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            |           |
| german               | de                     | Y                                      | Y                                      | Y                                       | Y                                |                                          | Y                               | Y                                  | Y                                | Y                                         |                                       | Y                                            |           |
| spanish              | es                     | Y                                      | Y                                      | Y                                       | Y(spa)                           | Y                                        | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            |           |
| portuguese           | pt                     | Y                                      | Y                                      | Y(pt/pt-pt)                             | Y                                | Y                                        | Y                               | Y                                  | Y                                | Y                                         |                                       | Y                                            |           |
| italian              | it                     | Y                                      | Y                                      | Y                                       | Y                                | Y                                        | Y                               | Y                                  | Y                                | Y                                         |                                       | Y                                            |           |
| japanese             | ja                     | Y                                      | Y                                      | Y                                       | Y(jp)                            |                                          | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            |           |
| korean               | ko                     | Y                                      | Y                                      | Y                                       | Y(kor)                           |                                          | Y                               | Y                                  | Y                                |                                           |                                       | Y                                            |           |
| greek                | el                     | Y                                      | Y                                      | Y                                       | Y                                |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| dutch                | nl                     | Y                                      | Y                                      | Y                                       | Y                                |                                          |                                 | Y                                  | Y                                | Y                                         |                                       |                                              |           |
| hindi                | hi                     | Y                                      | Y                                      | Y                                       |                                  |                                          | Y                               |                                    | Y                                |                                           |                                       | Y                                            |           |
| turkish              | tr                     | Y                                      | Y                                      | Y                                       |                                  | Y                                        | Y                               |                                    | Y                                |                                           |                                       | Y                                            |           |
| malay                | ms                     | Y                                      | Y                                      | Y                                       |                                  |                                          | Y                               |                                    | Y                                |                                           |                                       |                                              |           |
| thai                 | th                     | Y                                      | Y                                      | Y                                       | Y                                | Y                                        | Y                               |                                    | Y                                |                                           |                                       |                                              |           |
| vietnamese           | vi                     | Y                                      | Y                                      | Y                                       | Y(vie)                           | Y                                        | Y                               | Y                                  | Y                                |                                           |                                       | Y                                            |           |
| indonesian           | id                     | Y                                      | Y                                      | Y                                       |                                  | Y                                        | Y                               | Y                                  | Y                                |                                           |                                       | Y                                            |           |
| hebrew               | he                     | Y(iw)                                  | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| polish               | pl                     | Y                                      | Y                                      | Y                                       | Y                                |                                          |                                 |                                    | Y                                | Y                                         |                                       | Y                                            |           |
| mongolian            | mn                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| czech                | cs                     | Y                                      | Y                                      | Y                                       | Y                                |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| hungarian            | hu                     | Y                                      | Y                                      | Y                                       | Y                                |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| estonian             | et                     | Y                                      | Y                                      | Y                                       | Y(est)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| bulgarian            | bg                     | Y                                      | Y                                      | Y                                       | Y(bul)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| danish               | da                     | Y                                      | Y                                      | Y                                       | Y(dan)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| finnish              | fi                     | Y                                      | Y                                      | Y                                       | Y(fin)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| romanian             | ro                     | Y                                      | Y                                      | Y                                       | Y(rom)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| swedish              | sv                     | Y                                      | Y                                      | Y                                       | Y(swe)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| slovenian            | sl                     | Y                                      | Y                                      | Y                                       | Y(slo)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| persian/farsi        | fa                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| bosnian              | bs                     | Y                                      | Y                                      | Y(bs-Latn)                              |                                  |                                          |                                 |                                    | Y(bs-Latn)                       |                                           |                                       |                                              |           |
| serbian              | sr                     | Y                                      | Y                                      | Y(sr-Latn/sr-Cyrl)                      |                                  |                                          |                                 |                                    | Y(sr-Latn/sr-Cyrl)               |                                           |                                       |                                              |           |
| fijian               | fj                     |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| filipino             | tl                     | Y                                      | Y                                      | Y(fil)                                  |                                  |                                          |                                 |                                    | Y(fil)                           |                                           |                                       |                                              |           |
| haitiancreole        | ht                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| catalan              | ca                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| croatian             | hr                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| latvian              | lv                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| lithuanian           | lt                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| urdu                 | ur                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| ukrainian            | uk                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| welsh                | cy                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| tahiti               | ty                     |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| tongan               | to                     |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| swahili              | sw                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| samoan               | sm                     | Y                                      |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| slovak               | sk                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| afrikaans            | af                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| norwegian            | no                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| bengali              | bn                     | Y                                      | Y                                      | Y(bn-BD)                                |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| malagasy             | mg                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| maltese              | mt                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| queretaro otomi      | otq                    |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| klingon/tlhingan hol | tlh                    |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| gujarati             | gu                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| tamil                | ta                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| telugu               | te                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| punjabi              | pa                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| amharic              | am                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| azerbaijani          | az                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| bashkir              | ba                     |                                        | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| belarusian           | be                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| cebuano              | ceb                    | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| chuvash              | cv                     |                                        | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| esperanto            | eo                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| basque               | eu                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| irish                | ga                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| emoji                | emj                    |                                        | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| ...                  | ...                    |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |

<details>
<summary>About Chinese Language</summary>

| Language      | Language of Translator | [Google](https://translate.google.com) | [Yandex](https://translate.yandex.com) | [Bing](https://www.bing.com/Translator) | [Baidu](https://fanyi.baidu.com) | [Alibaba](https://translate.alibaba.com) | [Tencent](https://fanyi.qq.com) | [Youdao](https://fanyi.youdao.com) | [Sogou](https://fanyi.sogou.com) | [Iciba](https://www.iciba.com/fy) | [Iflytek](https://fanyi.xfyun.cn/console/trans/text) | [Caiyun](https://fanyi.caiyunapp.com) | [Deepl](https://www.deepl.com/translator) | [Argos](https://translate.argosopentech.com) | [Itranslate](https://itranslate.com/webapp) | [Reverso](https://www.reverso.net/text-translation) | [TranslateCom](https://www.translate.com/machine-translation) | [Papago](https://papago.naver.com) | [Utibet](http://mt.utibet.edu.cn/mt) |
| ------------- | ---------------------- | -------------------------------------- | -------------------------------------- | --------------------------------------- | -------------------------------- | ---------------------------------------- | ------------------------------- | ---------------------------------- | -------------------------------- | --------------------------------- | ---------------------------------------------------- | ------------------------------------- | ----------------------------------------- | -------------------------------------------- | ------------------------------------------- | --------------------------------------------------- | ------------------------------------------------------------- | ---------------------------------- | ------------------------------------ |
| Chinese(简体)   | zh-CHS                 | Y(zh-CN)                               | Y(zh)                                  | Y(zh-Hans)                              | Y(zh)                            | Y(zh)                                    | Y(zh)                           | Y                                  | Y                                | Y(zh)                             | Y(zh)                                                | Y(zh)                                 | Y(zh)                                     | Y(zh)                                        | Y(zh-CN)                                    | Y(zh/chi)                                           | ...                                                           | Y(zh-CN)                           | Y(zh)                                |
| Chinese(繁体)   | zh-CHT                 | Y(zh-TW)                               |                                        | Y(zh-Hant)                              | Y(cht)                           | Y(zh-TW)                                 |                                 |                                    | Y                                | Y(cnt)                            |                                                      |                                       |                                           |                                              | Y(zh-TW)                                    |                                                     |                                                               | Y(zh-TW)                           |                                      |
| Chinese(文言文)  | wyw                    |                                        |                                        |                                         | Y                                |                                          |                                 |                                    |                                  |                                   |                                                      |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    |                                      |
| Chinese(粤语)   | yue                    |                                        |                                        | Y                                       | Y                                |                                          |                                 |                                    | Y                                | Y                                 | Y                                                    |                                       |                                           |                                              | Y(zh-HK)                                    |                                                     |                                                               |                                    |                                      |
| Chinese(内蒙语)  | mn                     | N[外蒙]                                  | N[外蒙]                                  |                                         |                                  |                                          |                                 |                                    |                                  |                                   | Y[内蒙]                                                |                                       |                                           |                                              | N[外蒙]                                       |                                                     |                                                               |                                    |                                      |
| Chinese(维吾尔语) | uy                     |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  | Y                                 |                                                      |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    |                                      |
| Chinese(藏语)   | ti                     |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  | Y                                 |                                                      |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    | Y                                    |
| Chinese(白苗文)  | mww                    |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                | Y                                 |                                                      |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    |                                      |
| Chinese(彝语)   | ii                     |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  |                                   | Y                                                    |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    |                                      |
| Chinese(苗语)   | hmn                    |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  |                                   |                                                      |                                       |                                           |                                              | Y                                           |                                                     |                                                               |                                    |                                      |
| Chinese(壮语)   | zyb                    |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  |                                   |                                                      |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    |                                      |

</details>
</details>

<details>
<summary>Debug Tips</summary>

### Linux Runtime Environment

1. To support javascript runtime environment, you should [download and install Node.js](https://nodejs.org/en/download/).
2. Function baidu() doesn't work on Linux without desktop.

### HttpError 4xx

1. Check whether you made high frequency requests, especially httperror 429.
2. Check whether this service is provided in your region.
3. Detail to solve [HttpError](https://developer.mozilla.org/en-US/docs/Web/HTTP/Status) itself.
4. [Issue me](https://github.com/UlionTse/translators/issues), thanks.

### NetworkError or ProxyError

1. Check whether the network is connected correctly.
2. Check the proxy are enabled on your computer. If it is enabled, try turning it off or otherwise. 

</details>

<details>
<summary>Star History</summary>

[![Star History Chart](https://api.star-history.com/svg?repos=UlionTse/translators&type=Date)](https://star-history.com/#UlionTse/translators&Date)

</details>

