import os
from functools import wraps
import requests
from pathlib import Path

script_dir = os.path.dirname(__file__)
abs_file_path = os.path.join(script_dir, './df.config')
if Path(abs_file_path).is_file():
    pass
else:
    abs_file_path = os.path.join(script_dir, "../df.config")

config_file = open(abs_file_path)
contents = config_file.read().split("\n")
config_file.close()
keyline = [ x for x in contents if 'API_KEY' in x ]
key = keyline[0].split("=")[1]
os.environ['API_KEY'] = key

blackfin_URL = os.getenv('BLACKFIN_URL', "https://blackfin.local.mt.d.demystdata.com:8443/")
manta_URL = os.getenv('MANTA_URL', "https://manta.local.mt.d.demystdata.com:8443/")


class Provider:
    def __init__(self, name):
        self.name = name
        self.api_key = os.environ['API_KEY']

    def query(self, hsh):
        if(os.getenv('TEST')):
            return(self.sample_output())
        else:
            sample_params = {
                "providers": [self.name],
                "api_key": self.api_key,
                "inputs": hsh
            }
            # deploy with environment variable for blackfin and manta set
            r = requests.post(blackfin_URL + "/v2/execute", json=sample_params, verify=False)
            if(os.getenv('DEBUG')):
                print(r.url)
                print(r.text)
                print(r.status_code)
            if(r.status_code == 200):
                return(r.json()['output'][self.name]['data'])



    def required_inputs(self):
        input_query = {
            'api_key': self.api_key,
            'table_provider_names[]': [self.name]
        }
        r = requests.get(manta_URL + '/table_providers/required_input', params=input_query, verify=False )
        if(os.getenv('DEBUG')):
            print(r.url)
            print(r.text)
        return(r.json())

    def sample_output(self):
        sample_params = {
            "providers": [self.name],
            "api_key": self.api_key,
            "inputs": {
                "email_address": "maxpospischil@gmail.com",
                "country": "us"
            },
            "config":{"mode": "sample"}
        }
        r = requests.post(blackfin_URL + "/v2/execute", json=sample_params, verify=False)

        if(os.getenv('DEBUG')):
            print(r.url)
            print(r.text)
        ret_val = r.json()

        if(os.getenv("ALL_BLANK")):
            ret_val['output'][self.name]['data'] = {}
            return(ret_val)
        else:
            return(ret_val)

    def output_keys(self):
        return(self.sample_output()['output'][self.name]['data'].keys())


def provider(provider_name):
    """Returns an object that can be used to pull data from demyst
    required_inputs
    sample_output
    """
    return Provider(provider_name)
