import requests
import json
import sys
import os

sys.path.append(os.path.dirname(__file__) + "/../function") # for the function.py
import function

import unittest

class TestFunction(unittest.TestCase):
    def setUp(self):
        pass

    def test_reading_from_mock_tunnel_file(self):
        with open(sys.path[0] + "/../tmp/mock_tunnel_part_one.json", "r") as mock_tunnel_file:
            mock_tunnel_file_contents = mock_tunnel_file.read()
            mt_hash = json.loads(mock_tunnel_file_contents)
            call_channel_hash = json.load(open(sys.path[0] + "/../examples/call_channel.json"))
            if(mt_hash is None):
                mt_hash = {}

            mt_hash['config'] = { 'mode': 'sample' }
            mt_hash['inputs'] = call_channel_hash['inputs']
            api_key = os.environ['API_KEY']
            mt_hash['api_key'] = api_key
            data_bus_id = os.environ['CHANNEL_ID']
            mt_hash['id'] = data_bus_id

            pipe_name = os.environ['PIPE_NAME']
            our_local_data_function_result = function.data_function(mt_hash)
            print("")
            print("Our data function result being sent back to the channel ")
            print(json.dumps(our_local_data_function_result, indent=4, sort_keys=True))

            mt_hash = json.loads(json.dumps(mt_hash))
            mt_hash['pipe'] = {
                "name": pipe_name,
                "lambda_response_body": {
                    "result": our_local_data_function_result
                }
            }

            blackfin_url = os.environ['BLACKFIN_URL'] + "v2/channel/mock_function_output"
            headers = {'Content-Type': 'application/json'}

            mock_tunnel_part_two_response = requests.post(blackfin_url, data=json.dumps(mt_hash), headers=headers, verify=False)
            print("")
            print("The channel result built from our data function result")
            print(json.dumps(mock_tunnel_part_two_response.json(), indent=4, sort_keys=True))



if __name__ == '__main__':
    unittest.main()
