from __future__ import print_function
import json

# https://urllib3.readthedocs.io/en/latest/advanced-usage.html#ssl-warnings
import logging
logging.captureWarnings(True)

def data_function(data):

    deceased = False
    inf_deliverable = False
    email_exists = False
    domain_exists = False
    ad_active = False
    ph_active = False
    escore = 0.0
    ipscore = 0.0
    inf_score = 0.0
    ic_first = ""
    ic_last = ""
    ic_phone = ""

    # Inputs

    inputs = data['inputs']
    first_name    = inputs['first_name']
    last_name     = inputs['last_name']
    email_address = inputs['email_address']
    phone         = inputs['phone']
    street        = inputs['street']
    city          = inputs['city']
    state         = inputs['state']

    if(data.get('input') is not None):
        # EmailAge
        if(data['input'].get('email_age') is not None):
            email_age = data['input']['email_age']['data']
            escore        = email_age['score']
            ipscore       = email_age['ip']['risk_score']
            ipscore       = ipscore or 0.0
            email_exists  = email_age['email_exists']
            domain_exists = email_age['domain_exists']
            ea_name       = email_age['name']

        # Whitepages
        if(data['input'].get('white_pages_pro') is not None):
            whitepages = data['input']['white_pages_pro']['data']
            wp_name   = whitepages['email_address_registered_name']
            deceased  = whitepages['phone_subscriber_deceased']
            ad_active = whitepages['address_is_active']
            ph_active = whitepages['phone_is_valid']

        # info_connect
        if(data['input'].get('info_connect_individual') is not None):
            infoconnect = data['input']['info_connect_individual']['data']
            ic_first    = infoconnect.get('first_name')
            ic_last     = infoconnect.get('last_name')
            ic_phone    = infoconnect.get('phone')
            ic_postcode = infoconnect.get('post_code')

         # infutor
        if(data['input'].get('infutor_phone_owner_id_validation') is not None):
            infutor = data['input']['infutor_phone_owner_id_validation']['data']
            inf_first       = infutor['first_name']
            inf_last        = infutor['last_name']
            inf_score       = infutor['score']
            inf_deliverable = infutor['address_deliverable']

    id_score = 0

#    print("deceased", deceased)
#    print("inf_deliverable", inf_deliverable)
#    print("email_exists", email_exists)
#    print("domain_exists", domain_exists)
#    print("ad_active", ad_active)
#    print("ph_active", ph_active)

    if (deceased == True):
        id_score -= 100
    if (inf_deliverable == False):
        id_score -= 30
    if (email_exists == False):
        id_score -= 20
    if (domain_exists == False):
        id_score -= 50
    if (ad_active == False):
        id_score -= 20
    if (ph_active == False):
        id_score -= 20

    id_score += escore/10.0
    id_score += ipscore/10.0
    id_score += inf_score/10.0
    if (ic_first == first_name):
        id_score += 20
    if (ic_last == last_name):
        id_score += 10
    if (ic_phone == phone):
        id_score += 5

    if (id_score > 80):
        id_outcome = 'Pass'
    elif(id_score > 20):
        id_outcome = 'Review'
    else:
        id_outcome = 'Reject'

    result = {
        "score": id_score,
        "decision": id_outcome
    }

    return result
