# Data Functions

Welcome to Demyst Data Functions!

The code for your data function is in function/function.py
Edit the function `data_function` and deploy it to change the result of your Channel.
You can also test your Channel locally by running the Mock Tunnel Example

First of all, install the required python libraries for Data Function Development by running `pip install -r function/requirements.txt` from inside the directory of your downloaded data function.

This SDK comes with a 'test' API key which will only return mock data.
If you want to pull real data,
 - Log into the console
 - Click on "Organization" on the left
 - Click on "API Auth" on the upper right
 - Click on "New API Key"
 - Copy the API Key from the page e.g. "Production API key generated is <<<api key here>>>. Please record. This value will not be stored."
 - Open the df.config file
 - Replace the existing value for API_KEY with the new API key

Now you can pull real data.


## Deploy
   `./data-function deploy`

  Deploys this data function.
  All necessary configuration is included in the .zip you downloaded in the df.config file.
  You should not ever need to edit the df.config file.
  The data function is available immediately after deploy completes.

## Help
   `./data-function help`

  Display help about data functions

## Call Channel
   `./data-function call_channel`

  Calls the Channel associated with this data function and returns the response.
  Can be used to test and examine the output of the Channel once the data function is deployed.
  Update the data function code and deploy again, then call_channel again to see instant updates!
  The JSON posted to the API is in ./examples/call_channel.json if you want to change
    what is sent to the API.

## Download
   `./data-function download`

  Downloads the most recently deployed code for the data function to your local machine

## Mock Tunnel
   `./examples/mock_tunnel_test.sh`

  Example file that shows how to test your data function without deploying it.
  `./examples/mock_tunnel_test.sh` posts data to the API just like call_channel does,
    but the API doesn't run the entire transaction at once.
  The API pauses at the moment when it would call your deployed data function
    and instead sends the data function inputs back to your local machine.
  Then the code in mock_tunnel.py is invoked with those inputs,
    and the response of executing this mock_tunnel.py file locally is sent
    back to the API.
  The API stitches everything together and the final result of the transaction
    is the API response