
import LikeDict

_propDict = LikeDict.LikeDict() # case-insensitive dictionary
_warnDict = LikeDict.LikeDict() # case-insensitive dictionary
def addFluid(name="MMH",PC=1195,TC=1053,PREF=14.7,TREF=530,DREF=0.0315,\
    VREF=4.42e-005,CREF=3.317e-006,TBOIL=650,CPREF=0.7,WTMOL=46.07,CPCONA=8.82,CPCONB=27,CPCONC=-12,\
    CPCOND=-0.7,DHVAP=376.9,SURF=0.0001932):

    _propDict[name] = list(map(float,[PC,TC,PREF,TREF,DREF,\
          VREF,CREF,TBOIL,CPREF,WTMOL,CPCONA,CPCONB,CPCONC,\
          CPCOND,DHVAP,SURF]))

def addSimilarFluid(name="CINCH", simName="MMH", DREF=0.0337, VREF=None):
    PC,TC,PREF,TREF,DREFsim,\
          VREFsim,CREF,TBOIL,CPREF,WTMOL,CPCONA,CPCONB,CPCONC,\
          CPCOND,DHVAP,SURF = _propDict[simName]
          
    if VREF==None:
        VREF = VREFsim
          
    _warnDict[name] = 1
          
    addFluid(name,PC,TC,PREF,TREF,DREF,\
        VREF,CREF,TBOIL,CPREF,WTMOL,CPCONA,CPCONB,CPCONC,\
        CPCOND,DHVAP,SURF)
    
def getRefProps( name="MMH" ):
    #C THIS ROUTINE RETURNS PROPELLANT PROPERTY DATA
    #C
    #C
    #C  OUTPUT
    #C     PC   =CRITICAL PRESSURE (PSIA)
    #C     TC   =CRITICAL TEMPERATURE (DEGR)
    #C     PREF =REFERENCE PRESSURE (PSIA)
    #C     TREF =REFERENCE TEMPERATURE (DEGR)
    #C     DREF =REFERENCE DENSITY (LBM/IN**3)
    #C     VREF =REFERENCE VISCOSITY (LB/IN/SEC)   convFact... 1 cp = 0.000056 lb/in/sec)
    #C     CREF =REFERENCE CONDUCTIVITY (BTU/IN/SEC/DEG R)
    #C     TBOIL=NORMAL BOILING POINT (DEGR)
    #C     CPREF=REFERENCE HEAT CAPACITY (BTU/DEG R/LBM)
    #C     WTMOL=MOLECULAR WEIGHT (LB/LBMOLE)
    #C     CPCONA=IDEAL HEAT CAPACITY CONSTANT (CP=A+B*TR+C*TR**2+D*TR**3)
    #C     CPCONB=IDEAL HEAT CAPACITY CONSTANT
    #C     CPCONC=IDEAL HEAT CAPACITY CONSTANT
    #C     CPCOND=IDEAL HEAT CAPACITY CONSTANT
    #C     DHVAP =HEAT OF VAPORIZATION AT NORMAL BOILING POINT (BTU/LBM)
    #C     SURF  =SURFACE TENSION (LBF/IN)
    #C     IERR  =ERROR FLAG (0=NO ERROR, 1=ERROR CONDITION)
    #C
    #C MMH,N2O4,N2H4,MHF-3,CLF5,MON-25,LO2,LH2,RP-1,CH4,LF2, UDMH
    #C  1    2    3    4     5    6     7   8   9   10  11   12
    #C
    #C NACID27 HC-Blend C3H8(nbp) C3H8(subcooled) NACID20 NACID36 NACID44
    #C   13      14      15       16                17      18      19
    #C
    #C 90%H2O2 TK   JP-X  Ethanol(C2H5OH)  M20+NH3
    #C   20    21    22    23               24

    # check for an MMH + N2H4 blend
    try:
        mmhFrac = float( name[1:] ) / 100.0
    except:
        mmhFrac = -1.0 # fails to have an mmhFrac in legal range
        
        
    if name[0] == 'M' and mmhFrac>=0.0 and mmhFrac<=1.0:
        if 1:#name not in _propDict:
            Pc1,Tc1,Pref1,Tref1,RhoRef1,\
                ViscRef1,CondRef1,Tnbp1,CpRef1,\
                WtMol1,CPCONA1,CPCONB1,CPCONC1,\
                CPCOND1,DHvap1,SurfRef1 = getRefProps( name='MMH' )
            Pc2,Tc2,Pref2,Tref2,RhoRef2,\
                ViscRef2,CondRef2,Tnbp2,CpRef2,\
                WtMol2,CPCONA2,CPCONB2,CPCONC2,\
                CPCOND2,DHvap2,SurfRef2 = getRefProps( name='N2H4' )

            n2h4Frac = 1.0 - mmhFrac
            DREF = RhoRef1*RhoRef2 / (mmhFrac*RhoRef2 + RhoRef1*n2h4Frac)
            
            PC = mmhFrac*Pc1 + n2h4Frac*Pc2
            TC = mmhFrac*Tc1 + n2h4Frac*Tc2
            PREF = mmhFrac*Pref1 + n2h4Frac*Pref2
            TREF = mmhFrac*Tref1 + n2h4Frac*Tref2
            VREF = mmhFrac*ViscRef1 + n2h4Frac*ViscRef2
            CREF = mmhFrac*CondRef1 + n2h4Frac*CondRef2
            TBOIL = mmhFrac*Tnbp1 + n2h4Frac*Tnbp2
            CPREF = mmhFrac*CpRef1 + n2h4Frac*CpRef2
            WTMOL = mmhFrac*WtMol1 + n2h4Frac*WtMol2
            CPCONA = mmhFrac*CPCONA1 + n2h4Frac*CPCONA2
            CPCONB = mmhFrac*CPCONB1 + n2h4Frac*CPCONB2
            CPCONC = mmhFrac*CPCONC1 + n2h4Frac*CPCONC2
            CPCOND = mmhFrac*CPCOND1 + n2h4Frac*CPCOND2
            DHVAP = mmhFrac*DHvap1 + n2h4Frac*DHvap2
            SURF = mmhFrac*SurfRef1 + n2h4Frac*SurfRef2
            
            _propDict[name] = list(map(float,[PC,TC,PREF,TREF,DREF,\
                  VREF,CREF,TBOIL,CPREF,WTMOL,CPCONA,CPCONB,CPCONC,\
                  CPCOND,DHVAP,SURF]))


    try:
        if _warnDict[name] :
            print("WARNING... ONLY Density (maybe Viscosity) correct in %s Properties"%name)
    except:
        pass

    try:
        return _propDict[name] 
    except:
        print("ERROR in prolib.py ... propellant",name,"is NOT in library")
        raise "PRISM detected user input error"

def getDictOfProps(name="MMH" ):
    
    PC,TC,PREF,TREF,DREF,\
          VREF,CREF,TBOIL,CPREF,WTMOL,CPCONA,CPCONB,CPCONC,\
          CPCOND,DHVAP,SURF = getRefProps( name )
    
    dataDict = LikeDict.LikeDict()
    dataDict['PC'] = PC
    dataDict['TC'] = TC
    dataDict['PREF'] = PREF
    dataDict['TREF'] = TREF
    dataDict['DREF'] = DREF
          
    dataDict['VREF'] = VREF
    dataDict['CREF'] = CREF
    dataDict['TBOIL'] = TBOIL
    dataDict['CPREF'] = CPREF
    dataDict['WTMOL'] = WTMOL
    dataDict['CPCONA'] = CPCONA
    dataDict['CPCONB'] = CPCONB
    dataDict['CPCONC'] = CPCONC
          
    dataDict['CPCOND'] = CPCOND
    dataDict['DHVAP'] = DHVAP
    dataDict['SURF'] = SURF
    
    return dataDict

addFluid(name="MMH",PC=1195.,TC=1053.,PREF=14.7,TREF=530.,DREF=0.0315,\
    VREF=4.42e-005,CREF=3.317e-006,TBOIL=650.,CPREF=0.7,WTMOL=46.07,CPCONA=8.82,CPCONB=27.,CPCONC=-12.,\
    CPCOND=-0.7,DHVAP=376.9,SURF=0.0001932)

addFluid(name="N2H4",PC=2131.,TC=1175.,PREF=14.7,TREF=530.,DREF=0.03626,\
    VREF=5.113e-005,CREF=6.55e-006,TBOIL=697.3,CPREF=0.7351,WTMOL=32.048,CPCONA=3.89,CPCONB=23.2,CPCONC=-9.818,\
    CPCOND=1.666,DHVAP=583,SURF=0.0003794)

addFluid(name="MHF3",PC=1373,TC=1077,PREF=14.7,TREF=530,DREF=0.03212,\
    VREF=4.53e-005,CREF=3.69e-006,TBOIL=653,CPREF=0.7196,WTMOL=43.41,CPCONA=7.73,CPCONB=26.5,CPCONC=-11.7,\
    CPCOND=-0.4,DHVAP=370.2,SURF=0.0002042)

addFluid(name="CLF5",PC=771,TC=749.4,PREF=14.7,TREF=530,DREF=0.06417,\
    VREF=1.83e-005,CREF=2.569e-006,TBOIL=467.3,CPREF=0.298,WTMOL=130.44,CPCONA=0.31,CPCONB=44.3,CPCONC=-18.33,\
    CPCOND=0,DHVAP=76.04,SURF=8.8e-005)

addFluid(name="N2O4",PC=1440.,TC=776.5,PREF=14.7,TREF=530.,DREF=0.05177,\
    VREF=2.22e-005,CREF=1.758e-006,TBOIL=529.8,CPREF=0.378,WTMOL=92.016,CPCONA=7.9,CPCONB=19.23,CPCONC=-5.018,\
    CPCOND=0.,DHVAP=178.2,SURF=0.0001433)

addFluid(name="MON3",PC=1440.,TC=776.5,PREF=14.7,TREF=530.,DREF=0.05177,\
    VREF=2.22e-005,CREF=1.758e-006,TBOIL=529.8,CPREF=0.378,WTMOL=92.016,CPCONA=7.9,CPCONB=19.23,CPCONC=-5.018,\
    CPCOND=0.,DHVAP=178.2,SURF=0.0001433)

# Estimated MON15 properties (simply interpolated with MON25 and N2O4)
addFluid(name="MON15",PC=1836,TC=759.,PREF=14.7,TREF=530,DREF=0.0506,\
    VREF=2.225e-005,CREF=1.758e-006,TBOIL=500,CPREF=0.353,WTMOL=73.2,CPCONA=7.54,CPCONB=14.53,CPCONC=-3.77,\
    CPCOND=0,DHVAP=180.0,SURF=0.0001433)

addFluid(name="MON25",PC=2100,TC=747.,PREF=14.7,TREF=530,DREF=0.049,\
    VREF=2.225e-005,CREF=1.758e-006,TBOIL=475.57,CPREF=0.336,WTMOL=60.7,CPCONA=7.54,CPCONB=14.53,CPCONC=-3.77,\
    CPCOND=0,DHVAP=181.2,SURF=0.0001433)

addFluid(name="LOX",PC=731.43,TC=278.25,PREF=14.7,TREF=162.34,DREF=71.24/1728.,\
    VREF=1.117e-005,CREF=2.049e-006,TBOIL=162.34,CPREF=0.405,WTMOL=32,CPCONA=6.903,CPCONB=-0.058,CPCONC=0.046,\
    CPCOND=0.00253,DHVAP=91.62,SURF=7.83e-005)

addFluid(name="LO2",PC=731.43,TC=278.25,PREF=14.7,TREF=162.34,DREF=71.24/1728.,\
    VREF=1.117e-005,CREF=2.049e-006,TBOIL=162.34,CPREF=0.405,WTMOL=32,CPCONA=6.903,CPCONB=-0.058,CPCONC=0.046,\
    CPCOND=0.00253,DHVAP=91.62,SURF=7.83e-005)

addFluid(name="LN2",PC=492.52,TC=227.15,PREF=14.7,TREF=139.24,DREF=.02912,\
    VREF=9.0E-6,CREF=1.938e-6,TBOIL=139.24,CPREF=.48793,WTMOL=28.013,CPCONA=6.903,CPCONB=-0.058,CPCONC=0.046,\
    CPCOND=0.00253,DHVAP=85.69,SURF=5.067e-5)

addFluid(name="LN2_160",PC=492.52,TC=227.15,PREF=47.5,TREF=160.0,DREF=46.867/1728.,\
    VREF=6.0E-6,CREF=1.633e-6,TBOIL=139.24,CPREF=.50867,WTMOL=28.013,CPCONA=6.903,CPCONB=-0.058,CPCONC=0.046,\
    CPCOND=0.00253,DHVAP=85.69,SURF=3.61e-5)

addFluid(name="LN2_162",PC=492.52,TC=227.15,PREF=53.131,TREF=162.34,DREF=46.449/1728.,\
    VREF=5.72E-6,CREF=1.6e-6,TBOIL=139.24,CPREF=.51219,WTMOL=28.013,CPCONA=6.903,CPCONB=-0.058,CPCONC=0.046,\
    CPCOND=0.00253,DHVAP=85.69,SURF=3.45225e-5)

addFluid(name="O2",PC=731.43,TC=278.25,PREF=14.7,TREF=162.34,DREF=71.24/1728.,\
    VREF=1.117e-005,CREF=2.049e-006,TBOIL=162.34,CPREF=0.405,WTMOL=32,CPCONA=6.903,CPCONB=-0.058,CPCONC=0.046,\
    CPCOND=0.00253,DHVAP=91.62,SURF=7.83e-005)

# parahydrogen H2, LH2 reentered on 4/9/2013 by C. Taylor from Refprop
addFluid(name="LH2",PC=186.49,TC=59.288,PREF=14.7,TREF=36.488,DREF=4.4217/1728.,\
    VREF=0.0000089569/12.,CREF=0.059812/3600/12,TBOIL=36.488,CPREF=2.3253,
    WTMOL=2.0159,CPCONA=6.952,CPCONB=-0.0153,CPCONC=0.00106,\
    CPCOND=-7.7e-006,DHVAP=191.89,SURF=0.00013193/12)
    
addFluid(name="H2",PC=186.49,TC=59.288,PREF=14.7,TREF=36.488,DREF=4.4217/1728.,\
    VREF=0.0000089569/12.,CREF=0.059812/3600/12,TBOIL=36.488,CPREF=2.3253,
    WTMOL=2.0159,CPCONA=6.952,CPCONB=-0.0153,CPCONC=0.00106,\
    CPCOND=-7.7e-006,DHVAP=191.89,SURF=0.00013193/12)
    
#addFluid(name="LH2",PC=188,TC=60,PREF=14.7,TREF=40,DREF=0.00249,\
#    VREF=6.25e-007,CREF=1.523e-006,TBOIL=36.5,CPREF=2.75,WTMOL=2.016,CPCONA=6.952,CPCONB=-0.0153,CPCONC=0.00106,\
#    CPCOND=-7.7e-006,DHVAP=195.3,SURF=9.2e-007)

#addFluid(name="H2",PC=188,TC=60,PREF=14.7,TREF=40,DREF=0.00249,\
#    VREF=6.25e-007,CREF=1.523e-006,TBOIL=36.5,CPREF=2.75,WTMOL=2.016,CPCONA=6.952,CPCONB=-0.0153,CPCONC=0.00106,\
#    CPCOND=-7.7e-006,DHVAP=195.3,SURF=9.2e-007)

addFluid(name="RP-1",PC=315,TC=1218,PREF=14.7,TREF=560,DREF=0.0285,\
    VREF=7e-005,CREF=1.8e-006,TBOIL=890,CPREF=0.49,WTMOL=172,CPCONA=-12.957,CPCONB=159.4,CPCONC=-110.5,\
    CPCOND=29.7,DHVAP=125,SURF=0.000277)

addFluid(name="RP1",PC=315,TC=1218,PREF=14.7,TREF=560,DREF=0.0285,\
    VREF=7e-005,CREF=1.8e-006,TBOIL=890,CPREF=0.49,WTMOL=172,CPCONA=-12.957,CPCONB=159.4,CPCONC=-110.5,\
    CPCOND=29.7,DHVAP=125,SURF=0.000277)

# JetA scaled from Frank Lu data
addFluid(name="JetA",PC=315,TC=1218,PREF=14.7,TREF=560,DREF=0.0285*0.815/0.81,\
    VREF=7e-005,CREF=1.8e-006,TBOIL=890,CPREF=0.49,WTMOL=172,CPCONA=-12.957,CPCONB=159.4,CPCONC=-110.5,\
    CPCOND=29.7,DHVAP=125,SURF=0.000277)

addFluid(name="CH4",PC=673.3,TC=343,PREF=15,TREF=170,DREF=0.01614,\
    VREF=9.167e-006,CREF=2.778e-006,TBOIL=201.4,CPREF=0.791,WTMOL=16.04,CPCONA=4.75,CPCONB=4.116,CPCONC=0.356,\
    CPCOND=-0.106,DHVAP=121.87,SURF=7.45e-007)

addFluid(name="LF2",PC=808.5,TC=259,PREF=14.7,TREF=160,DREF=0.05275,\
    VREF=1.333e-005,CREF=3.63e-006,TBOIL=155,CPREF=0.368,WTMOL=38,CPCONA=6.115,CPCONB=0.8438,CPCONC=-0.0867,\
    CPCOND=0.00292,DHVAP=71.5,SURF=7.08e-005)

addFluid(name="UDMH",PC=870,TC=941,PREF=14.7,TREF=530,DREF=0.0285,\
    VREF=2.92e-005,CREF=2.08e-006,TBOIL=605,CPREF=0.668,WTMOL=60.1,CPCONA=0.4036,CPCONB=0.4661,CPCONC=0,\
    CPCOND=0,DHVAP=251,SURF=0.000138)

addFluid(name="NACID27",PC=1281.2,TC=957.1,PREF=14.7,TREF=530,DREF=0.0543,\
    VREF=3.96e-005,CREF=2.8e-006,TBOIL=617.9,CPREF=0.414,WTMOL=68.99,CPCONA=7.9,CPCONB=19.23,CPCONC=-5.018,\
    CPCOND=1.666,DHVAP=250.5,SURF=0.000515)

addFluid(name="HC-Blend",PC=315,TC=1218,PREF=14.7,TREF=530,DREF=0.0285,\
    VREF=7e-005,CREF=1.8e-006,TBOIL=890,CPREF=0.49,WTMOL=118.3,CPCONA=-12.957,CPCONB=159.4,CPCONC=-110.5,\
    CPCOND=29.7,DHVAP=125,SURF=0.000277)

addFluid(name="C3H8(nbp)",PC=619,TC=666,PREF=14.7,TREF=416,DREF=0.02106,\
    VREF=8.8e-006,CREF=1.3e-006,TBOIL=416,CPREF=0.53,WTMOL=44.09,CPCONA=4.75,CPCONB=4.116,CPCONC=0.356,\
    CPCOND=-0.106,DHVAP=183,SURF=1.15e-005)

addFluid(name="C3H8",PC=619,TC=666,PREF=14.7,TREF=416,DREF=0.02106,\
    VREF=8.8e-006,CREF=1.3e-006,TBOIL=416,CPREF=0.53,WTMOL=44.09,CPCONA=4.75,CPCONB=4.116,CPCONC=0.356,\
    CPCOND=-0.106,DHVAP=183,SURF=1.15e-005)

addFluid(name="C3H8(subcooled)",PC=619,TC=666,PREF=14.7,TREF=160,DREF=0.02637,\
    VREF=0.00075,CREF=2.04e-006,TBOIL=416,CPREF=0.53,WTMOL=44.09,CPCONA=4.75,CPCONB=4.116,CPCONC=0.356,\
    CPCOND=-0.106,DHVAP=183,SURF=3.36e-005)

addFluid(name="NACID20",PC=1271.4,TC=968.3,PREF=14.7,TREF=530,DREF=0.0544,\
    VREF=4.07e-005,CREF=2.86e-006,TBOIL=623.3,CPREF=0.416,WTMOL=67.57,CPCONA=7.9,CPCONB=19.23,CPCONC=-5.018,\
    CPCOND=1.666,DHVAP=254.9,SURF=0.000538)

addFluid(name="NACID36",PC=1295.6,TC=940.8,PREF=14.7,TREF=530,DREF=0.054,\
    VREF=3.81e-005,CREF=2.71e-006,TBOIL=609.9,CPREF=0.41,WTMOL=71.08,CPCONA=7.9,CPCONB=19.23,CPCONC=-5.018,\
    CPCOND=1.666,DHVAP=243.9,SURF=0.000481)

addFluid(name="NACID44",PC=1310,TC=924.4,PREF=14.7,TREF=530,DREF=0.0538,\
    VREF=3.65e-005,CREF=2.61e-006,TBOIL=601.9,CPREF=0.407,WTMOL=73.17,CPCONA=7.9,CPCONB=19.23,CPCONC=-5.018,\
    CPCOND=1.666,DHVAP=237.4,SURF=0.000448)

addFluid(name="90%H2O2",PC=3156.4,TC=1289,PREF=14.7,TREF=530,DREF=0.0493,\
    VREF=5.59e-005,CREF=6.76e-006,TBOIL=746.7,CPREF=0.707,WTMOL=31.24,CPCONA=6.903,CPCONB=-0.058,CPCONC=0.046,\
    CPCOND=0.00253,DHVAP=660.9,SURF=0.000432)

addFluid(name="TK",PC=315,TC=1218,PREF=14.7,TREF=530,DREF=0.0285,\
    VREF=7e-005,CREF=1.8e-006,TBOIL=890,CPREF=0.49,WTMOL=110.3,CPCONA=-12.957,CPCONB=159.4,CPCONC=-110.5,\
    CPCOND=29.7,DHVAP=125,SURF=0.000277)

addFluid(name="JPX",PC=315,TC=1218,PREF=14.7,TREF=530,DREF=0.0285,\
    VREF=7e-005,CREF=1.8e-006,TBOIL=890,CPREF=0.49,WTMOL=79.02,CPCONA=-12.957,CPCONB=159.4,CPCONC=-110.5,\
    CPCOND=29.7,DHVAP=125,SURF=0.000277)

addFluid(name="Ethanol",PC=897,TC=925,PREF=14.7,TREF=530,DREF=0.0285,\
    VREF=6.528e-005,CREF=2.222e-006,TBOIL=632.5,CPREF=0.6042,WTMOL=46.07,CPCONA=4.75,CPCONB=4.116,CPCONC=0.356,\
    CPCOND=-0.106,DHVAP=398.1,SURF=0.000127)

addFluid(name="Methanol",PC=1175,TC=922.7,PREF=14.7,TREF=530,DREF=0.02853,\
    VREF=6.528e-005,CREF=2.222e-006,TBOIL=607.7,CPREF=0.60045,WTMOL=32.042,CPCONA=4.75,CPCONB=4.116,CPCONC=0.356,\
    CPCOND=-0.106,DHVAP=505.3,SURF=0.000129)

# these three entries are all for AM20 
# backed Tc, Pc, Tnbp out of Pvap curve fit Pvp=0.57T-3.54 where T=degF in range 40 to 120 F
for name in ["M20+NH3", "M20_NH3", "M20_5NH3", "AM20"]:
    addFluid(name=name,PC=1438,TC=1022,PREF=14.7,TREF=520,DREF=0.035187,\
        VREF=5.113e-005,CREF=6.55e-006,TBOIL=474.4,CPREF=0.7351,WTMOL=32,CPCONA=3.89,CPCONB=23.2,CPCONC=-9.818,\
        CPCOND=-0.4,DHVAP=583,SURF=0.0003794)
    

addFluid(name="A50",PC=1731,TC=1093,PREF=14.7,TREF=560,DREF=0.0325,\
    VREF=4.4e-005,CREF=3.86e-006,TBOIL=618,CPREF=0.74,WTMOL=41.802,CPCONA=3.89,CPCONB=23.2,CPCONC=-9.818,\
    CPCOND=1.666,DHVAP=346.5,SURF=0.0003794)

addFluid(name="IRFNA",PC=1286,TC=980,PREF=14.7,TREF=530,DREF=0.056,\
    VREF=5.55e-006,CREF=4.125e-006,TBOIL=608,CPREF=0.41,WTMOL=59.7,CPCONA=3.89,CPCONB=19.23,CPCONC=-5.018,\
    CPCOND=1.666,DHVAP=247,SURF=0.0001433)

# nitrous oxide
addFluid(name="N2O",PC=1052.1,TC=557.2,PREF=800,TREF=530,DREF=0.02819,\
    VREF=2.22e-005,CREF=1.758e-006,TBOIL=332.48,CPREF=0.7627,WTMOL=44.01,CPCONA=7.9,CPCONB=19.23,CPCONC=-5.018,\
    CPCOND=1.666,DHVAP=70.225,SURF=9.485e-006)

# nitrous oxide an NBP... props from Refprop
addFluid(name="N2O_nbp",PC=1050.8,TC=557.136,
    PREF=14.7,TREF=332.424,DREF=0.0444532,
    VREF=1.81279e-005,CREF=2.68816e-006,TBOIL=332.424,CPREF=0.41086,WTMOL=44.0128,
    CPCONA=0.0,CPCONB=0.0,CPCONC=0.0,CPCOND=0.0,DHVAP=161.022,SURF=0.000136)

# SimMono is ONLY added to fix low Tboil of N2O4.  otherwise N2O4 would be the simName
addFluid(name="SimMono",PC=1440,TC=776.5,PREF=14.7,TREF=530,DREF=0.05177,\
    VREF=2.22e-005,CREF=1.758e-006,TBOIL=550.0,CPREF=0.378,WTMOL=92.016,CPCONA=7.9,CPCONB=19.23,CPCONC=-5.018,\
    CPCOND=0,DHVAP=178.2,SURF=0.0001433)


addFluid(name="Water",PC=3200.0,TC=1164.8,PREF=14.7,TREF=530,DREF=0.03605,\
    VREF=5.4356e-005,CREF=8.04e-006,TBOIL=671.62,CPREF=0.99981,WTMOL=18.015,CPCONA=6.903,CPCONB=-0.058,CPCONC=0.046,\
    CPCOND=0.00253,DHVAP=1054.2,SURF=0.0004142)


# generated from refprop... surface tension from web = 21.16 dyne/cm
addFluid(name="C2H6",PC=706.653,TC=549.58,
    PREF=14.7,TREF=332.224,DREF=0.0196471,
    VREF=9.31632e-006,CREF=0.0965368,TBOIL=332.224,CPREF=0.583051,WTMOL=30.069,
    CPCONA=0.0,CPCONB=0.0,CPCONC=0.0,CPCOND=0.0,DHVAP=210.547,SURF=0.0001208)

# generated from refprop... surface tension from web at http://webbook.nist.gov/chemistry/fluid/
addFluid(name="NH3",PC=1643.71,TC=729.72,
    PREF=14.7,TREF=431.681,DREF=0.0246378,
    VREF=1.43064e-005,CREF=0.384883,TBOIL=431.681,CPREF=1.06307,WTMOL=17.0303,
    CPCONA=0.0,CPCONB=0.0,CPCONC=0.0,CPCOND=0.0,DHVAP=589.173,SURF=0.000256)

# generated from refprop...         Propylene and Propene are the same thing
addFluid(name="Propylene",PC=660.647,TC=655.58,
    PREF=14.7,TREF=405.954,DREF=0.0220398,
    VREF=1.09693e-005,CREF=2.17473e-006,TBOIL=405.954,CPREF=0.524043,WTMOL=42.0797,
    CPCONA=0.0,CPCONB=0.0,CPCONC=0.0,CPCOND=0.0,DHVAP=188.845,SURF=0.0000955)

# generated from refprop... 
addFluid(name="PropyleneRT",PC=660.647,TC=655.58,
    PREF=152.594,TREF=530,DREF=0.0185196,
    VREF=5.56683e-006,CREF=1.63384e-006,TBOIL=405.954,CPREF=0.626376,WTMOL=42.0797,
    CPCONA=0.0,CPCONB=0.0,CPCONC=0.0,CPCOND=0.0,DHVAP=147.105,SURF=0.00048/12.)

# generated from refprop... 
# generated from refprop... 
addFluid(name="PropaneRT",PC=616.584,TC=665.802,
    PREF=125.607,TREF=530,DREF=0.0179947,
    VREF=5.65198e-006,CREF=1.2776e-006,TBOIL=415.865,CPREF=0.640387,WTMOL=44.0956,
    CPCONA=0.0,CPCONB=0.0,CPCONC=0.0,CPCOND=0.0,DHVAP=147.19,SURF=0.0005097/12.)
    
addFluid(name="C3H8RT",PC=616.584,TC=665.802,
    PREF=125.607,TREF=530,DREF=0.0179947,
    VREF=5.65198e-006,CREF=1.2776e-006,TBOIL=415.865,CPREF=0.640387,WTMOL=44.0956,
    CPCONA=0.0,CPCONB=0.0,CPCONC=0.0,CPCOND=0.0,DHVAP=147.19,SURF=0.0005097/12.)
    
# generated from refprop... 
# generated from refprop... 
addFluid(name="EthaneRT",PC=706.653,TC=549.58,
    PREF=561.68,TREF=530,DREF=0.012048,
    VREF=2.27722e-006,CREF=9.93568e-007,TBOIL=332.224,CPREF=1.46692,WTMOL=30.069,
    CPCONA=0.0,CPCONB=0.0,CPCONC=0.0,CPCOND=0.0,DHVAP=84.9789,SURF=0.00005506/12.)
    
addFluid(name="C2H6RT",PC=706.653,TC=549.58,
    PREF=561.68,TREF=530,DREF=0.012048,
    VREF=2.27722e-006,CREF=9.93568e-007,TBOIL=332.224,CPREF=1.46692,WTMOL=30.069,
    CPCONA=0.0,CPCONB=0.0,CPCONC=0.0,CPCOND=0.0,DHVAP=84.9789,SURF=0.00005506/12.)
    
# generated from web at http://en.wikipedia.org/wiki/Isopropyl_alcohol
#  1 centipoise = 0.000671969 pound/foot second = 0.000056 lbf/in s
# guessed... CREF, SURF,
addFluid(name="Isopropanol",PC=691.0,TC=915.0,
    PREF=14.7,TREF=530.,DREF=0.02839605,
    VREF=0.000112,CREF=1.3e-006,TBOIL=640.,CPREF=0.557,WTMOL=60.09,
    CPCONA=0.0,CPCONB=0.0,CPCONC=0.0,CPCOND=0.0,DHVAP=326.0,SURF=1.15e-005)


#WARNING... ONLY Density,Viscosity correct in HAN269 Properties
addSimilarFluid(name="HAN269", simName="SimMono", DREF=0.05119237, VREF=0.00056) # 10 cp
    
#WARNING... ONLY Density,Viscosity correct in HAN315 Properties
addSimilarFluid(name="HAN315", simName="SimMono", DREF=0.05293, VREF=0.001406)

#WARNING... ONLY Density,Viscosity correct in HPB24 Properties
addSimilarFluid(name="HPB24", simName="SimMono", DREF=0.040104, VREF=7.896e-005)
    
#WARNING... ONLY Density (maybe Viscosity) correct in CINCH Properties
addSimilarFluid(name="CINCH", simName="MMH", DREF=0.0337, VREF=0.0001141)

addSimilarFluid(name="ECP-dimer", simName="RP-1", DREF=0.0329, VREF=None)
    
#WARNING... ONLY Density correct in VLM Properties ( 1 SG = 0.03612729 lbm/cuin )
addSimilarFluid(name="VLM233", simName="SimMono", DREF=0.04949439, VREF=0.002)
addSimilarFluid(name="VLM245", simName="SimMono", DREF=1.27 * 0.03612729, VREF=0.002)
addSimilarFluid(name="VLM243", simName="SimMono", DREF= 1.32 * 0.03612729, VREF=0.002)
addSimilarFluid(name="VLM244", simName="SimMono", DREF= 1.295 * 0.03612729, VREF=0.002)



if __name__ == "__main__": #Self Test
    print('   for MMH')    
    print(getRefProps( name="MMH" ))
    print()
    print('   for M20')
    print(getRefProps( name="M20" ))
    
    print()
    print( getDictOfProps( "M20" ) )
    
    if 0:
      propList = list(_propDict.keys())
      propList.sort()
      
      for name in propList:
          print(name)
          print(getRefProps( name ))

