# coding: utf-8

#
# Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file
# except in compliance with the License. A copy of the License is located at
#
# http://aws.amazon.com/apache2.0/
#
# or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for
# the specific language governing permissions and limitations under the License.
#

import pprint
import re  # noqa: F401
import six
import typing
from enum import Enum


if typing.TYPE_CHECKING:
    from typing import Dict, List, Optional, Union, Any
    from datetime import datetime
    from ask_smapi_model.v1.skill.interaction_model.type_value_object import TypeValueObject as TypeValueObject_a6f9c062


class TypeValue(object):
    """
    The value schema in type object of interaction model.


    :param id: 
    :type id: (optional) str
    :param name: 
    :type name: (optional) ask_smapi_model.v1.skill.interaction_model.type_value_object.TypeValueObject

    """
    deserialized_types = {
        'id': 'str',
        'name': 'ask_smapi_model.v1.skill.interaction_model.type_value_object.TypeValueObject'
    }  # type: Dict

    attribute_map = {
        'id': 'id',
        'name': 'name'
    }  # type: Dict
    supports_multiple_types = False

    def __init__(self, id=None, name=None):
        # type: (Optional[str], Optional[TypeValueObject_a6f9c062]) -> None
        """The value schema in type object of interaction model.

        :param id: 
        :type id: (optional) str
        :param name: 
        :type name: (optional) ask_smapi_model.v1.skill.interaction_model.type_value_object.TypeValueObject
        """
        self.__discriminator_value = None  # type: str

        self.id = id
        self.name = name

    def to_dict(self):
        # type: () -> Dict[str, object]
        """Returns the model properties as a dict"""
        result = {}  # type: Dict

        for attr, _ in six.iteritems(self.deserialized_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else
                    x.value if isinstance(x, Enum) else x,
                    value
                ))
            elif isinstance(value, Enum):
                result[attr] = value.value
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else
                    (item[0], item[1].value)
                    if isinstance(item[1], Enum) else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        # type: () -> str
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        # type: () -> str
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        # type: (object) -> bool
        """Returns true if both objects are equal"""
        if not isinstance(other, TypeValue):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        # type: (object) -> bool
        """Returns true if both objects are not equal"""
        return not self == other
