# pyOCD debugger
# Copyright (c) 2017 NXP
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ...flash.flash import Flash
from ...coresight.coresight_target import CoreSightTarget
from ...core.memory_map import (FlashRegion, RomRegion, RamRegion, MemoryMap)
from ...debug.svd.loader import SVDFile
from ..family.target_imxrt import IMXRT

FLASH_ALGO = {
    'load_address' : 0x20000000,

    # Flash algorithm as a hex string
    'instructions': [
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770bac0, 0x4770bac0, 0x4770bac0, 0x4855b51c, 0x48559000,
    0x08498901, 0x81010049, 0x890a4953, 0x00520852, 0x8802810a, 0x07522304, 0xda022a00, 0x439a8802,
    0x88088002, 0xd5020740, 0x43988808, 0x484c8008, 0x6041494a, 0x6081494b, 0x22806801, 0x22204391,
    0x60014311, 0xf8a8f000, 0x68014847, 0xd54503c9, 0x60014946, 0x29006801, 0x6b01dafc, 0x03122201,
    0x63014391, 0x29006b01, 0x4a42dafc, 0x60114940, 0x03092103, 0x69016101, 0xdafc2900, 0x22016901,
    0x43910412, 0x4b3b6101, 0x3b40493b, 0x493b6319, 0x610b2301, 0x4c3a694b, 0x00544023, 0x2405191b,
    0x43230264, 0x698b614b, 0x40234c36, 0x04a42403, 0x4c35191b, 0x618b4323, 0x4c3469cb, 0x24034023,
    0x191b0764, 0x43234c32, 0x680161cb, 0x60014391, 0x43916b01, 0x69016301, 0x61014391, 0x466a492d,
    0x20004449, 0xf9d3f000, 0xd1052800, 0x44494929, 0xf9b8f000, 0xd0002800, 0xbd1c2001, 0x47702000,
    0xb5104924, 0x20004449, 0xf9bbf000, 0xd0002800, 0xbd102001, 0x07492105, 0x491e1842, 0x2301b510,
    0x4449041b, 0xf0002000, 0x2800f9b8, 0x2001d000, 0x2105bd10, 0x07494613, 0x49161842, 0x4449b510,
    0xf0002000, 0x2800f995, 0x2001d000, 0x0000bd10, 0xc0000006, 0x400b8000, 0x400d0000, 0xd928c520,
    0x400bc000, 0x0000ffff, 0x400d8000, 0x00012018, 0x18131818, 0x400d8100, 0x0f1a2323, 0x400fc000,
    0xfff8e0ff, 0x1ff3fcff, 0xe0000100, 0x9c7fff80, 0x03800001, 0x0000000c, 0x49d42001, 0x69c00540,
    0x60084449, 0x4ad14770, 0x6812444a, 0x68526992, 0x49ce4710, 0x68094449, 0x68896989, 0x4acb4708,
    0x6812444a, 0x68d26992, 0x49c84710, 0x68094449, 0x69096989, 0x4ac54708, 0x6812444a, 0x69526992,
    0x49c24710, 0x68094449, 0x69896989, 0x49bf4708, 0x68094449, 0x69c96989, 0x49bc4708, 0x68094449,
    0x6a096989, 0x4bb94708, 0x681b444b, 0x6a5b699b, 0x48b64718, 0x68004448, 0x6ac06980, 0x48b34700,
    0x68004448, 0x6bc06980, 0x49b04700, 0x68094449, 0x6c096989, 0x49ad4708, 0x68094449, 0x6c496989,
    0x49aa4708, 0x68094449, 0x6b096989, 0x48a74708, 0x68004448, 0x6b406980, 0x49a44700, 0x68094449,
    0x6b896989, 0x48a14708, 0x68004448, 0x6c806980, 0x489e4700, 0x68004448, 0x6cc06980, 0x499b4700,
    0x68094449, 0x6a896989, 0x4a984708, 0x6812444a, 0x32806992, 0x47106a52, 0x444a4a94, 0x69926812,
    0x6b123280, 0x4a914710, 0x6812444a, 0x32806992, 0x47106a92, 0x4448488d, 0x69806800, 0x6ac03080,
    0x498a4700, 0x68094449, 0x6d096989, 0x48874708, 0x68004448, 0x6d406980, 0x49844700, 0x68094449,
    0x6d896989, 0x48814708, 0x68004448, 0x6dc06980, 0x497e4700, 0x68094449, 0x6e096989, 0x487b4708,
    0x68004448, 0x6e406980, 0x49784700, 0x68094449, 0x6e896989, 0x48754708, 0x68004448, 0x6ec06980,
    0x49724700, 0x68094449, 0x6f096989, 0x486f4708, 0x68004448, 0x6f406980, 0x496c4700, 0x68094449,
    0x6f896989, 0x48694708, 0x68004448, 0x6fc06980, 0x49664700, 0x68094449, 0x31806989, 0x47086809,
    0x44484862, 0x69806800, 0x68403080, 0x495f4700, 0x68094449, 0x31806989, 0x47086889, 0x444a4a5b,
    0x69926812, 0x68d23280, 0x49584710, 0x68094449, 0x31806989, 0x47086909, 0x444a4a54, 0x69926812,
    0x69523280, 0x49514710, 0x68094449, 0x31806989, 0x47086989, 0x4449494d, 0x69896809, 0x69c93180,
    0x494a4708, 0x68094449, 0x31806989, 0x47086a09, 0x444a4a46, 0x69926812, 0x6b523280, 0x48434710,
    0x68004448, 0x30806980, 0x47006b80, 0x444a4a3f, 0x69d26812, 0x47106a12, 0x4449493c, 0x69c96809,
    0x47086809, 0x444a4a39, 0x69d26812, 0x47106852, 0x44494936, 0x69c96809, 0x47086889, 0x44494933,
    0x6a096809, 0x47086809, 0x444a4a30, 0x6a126812, 0x47106852, 0x4449492d, 0x6a096809, 0x47086889,
    0x4449492a, 0x6a096809, 0x47086989, 0x444a4a27, 0x6a126812, 0x471069d2, 0x44494924, 0x6a096809,
    0x47086ac9, 0x444a4a21, 0x69126812, 0x47106852, 0x4c1eb430, 0x6824444c, 0x68a46924, 0xbc3046a4,
    0x4a1a4760, 0x6812444a, 0x68d26912, 0x4b174710, 0x681b444b, 0x6a5b691b, 0xb4304718, 0x444c4c13,
    0x69246824, 0x46a46924, 0x4760bc30, 0x9c04b538, 0x4c0e9400, 0x6824444c, 0x69646924, 0xbd3847a0,
    0x4c0ab430, 0x6824444c, 0x6a246924, 0xbc3046a4, 0x4a064760, 0x6812444a, 0x69d26912, 0x49034710,
    0x68094449, 0x69896909, 0x00004708, 0x00000004, 0xb5104770, 0x89014857, 0x00490849, 0x49568101,
    0x0852890a, 0x810a0052, 0x23048802, 0x2a000752, 0x8802da02, 0x8002439a, 0x07408808, 0x8808d502,
    0x80084398, 0x494d484e, 0x494e6041, 0x68016081, 0x43912280, 0x43112220, 0x484b6001, 0x07c96901,
    0x6901d003, 0x00490849, 0xf7ff6101, 0xbd10ffd1, 0x4d46b5f8, 0x4a466968, 0x01804946, 0x69a8d522,
    0x031b2303, 0xd0074018, 0x031b2301, 0xd00c1ac0, 0xd1084298, 0xe0066b10, 0x03c06910, 0xd5066910,
    0x0f800400, 0x2000d001, 0x4608e008, 0x0780e006, 0x2016d501, 0x2014e000, 0x43484936, 0x00896969,
    0xe03d0f49, 0x03c06810, 0xd5066810, 0x0f800400, 0x2700d001, 0x460fe006, 0x0640e004, 0x0e404b2d,
    0x08474358, 0x03c06b10, 0xd5066b10, 0x0f800400, 0x2400d001, 0x460ce008, 0x07c0e006, 0x2416d001,
    0x2414e000, 0x43444823, 0x30404821, 0x69006a06, 0xf976f000, 0x23004632, 0xf844f000, 0x190069a9,
    0x40114a1d, 0x2201d011, 0x4b1c0492, 0xd0161a89, 0xd0171a89, 0xd1074291, 0x07416928, 0x46380f49,
    0xf0001c49, 0xe000f8b0, 0x69692000, 0x0f4904c9, 0xf0001c49, 0x4912f8a8, 0x60084449, 0x6819bdf8,
    0xe0000c09, 0x06896819, 0xf0000e89, 0x2112f89c, 0xe7ea4348, 0x400b8000, 0x400d0000, 0xd928c520,
    0x400bc000, 0x0000ffff, 0xe000e000, 0x400fc000, 0x400d8000, 0x016e3600, 0x000c0000, 0x400d8100,
    0x00000008, 0x4605b5fe, 0x460c4610, 0xd0734318, 0x468c46ae, 0x1aad2000, 0x419c4601, 0x4666d367,
    0x24012700, 0x1ab6463d, 0xd302419d, 0x463a4613, 0x46652421, 0x042f4676, 0x433e0c36, 0x1ab60c2d,
    0xd304419d, 0x041b0c15, 0x0412432b, 0x46653410, 0x062f4676, 0x433e0a36, 0x1ab60a2d, 0xd304419d,
    0x021b0e15, 0x0212432b, 0x46653408, 0x072f4676, 0x433e0936, 0x1ab6092d, 0xd304419d, 0x011b0f15,
    0x0112432b, 0x46651d24, 0x07af4676, 0x433e08b6, 0x1ab608ad, 0xd304419d, 0x009b0f95, 0x0092432b,
    0x46651ca4, 0x07ef4676, 0x433e0876, 0x1ab6086d, 0xd31a419d, 0x415b1892, 0xe0161c64, 0x46761800,
    0x41494665, 0x419d1ab7, 0x90009101, 0x4660d309, 0x41981ab1, 0x4684468e, 0x99019800, 0x1c402500,
    0x07dd4169, 0x432a0852, 0x1e64085b, 0x4672d5e6, 0xb0034663, 0xe7ffbdf0, 0x46012000, 0x46c046c0,
    0x4623462a, 0x2200e7f5, 0x428b0903, 0x0a03d32c, 0xd311428b, 0x469c2300, 0x4603e04e, 0xd43c430b,
    0x08432200, 0xd331428b, 0x428b0903, 0x0a03d31c, 0xd301428b, 0xe03f4694, 0x428b09c3, 0x01cbd301,
    0x41521ac0, 0x428b0983, 0x018bd301, 0x41521ac0, 0x428b0943, 0x014bd301, 0x41521ac0, 0x428b0903,
    0x010bd301, 0x41521ac0, 0x428b08c3, 0x00cbd301, 0x41521ac0, 0x428b0883, 0x008bd301, 0x41521ac0,
    0x428b0843, 0x004bd301, 0x41521ac0, 0xd2001a41, 0x41524601, 0x47704610, 0x0fcae05d, 0x4249d000,
    0xd3001003, 0x40534240, 0x469c2200, 0x428b0903, 0x0a03d32d, 0xd312428b, 0x018922fc, 0x0a03ba12,
    0xd30c428b, 0x11920189, 0xd308428b, 0x11920189, 0xd304428b, 0xd03a0189, 0xe0001192, 0x09c30989,
    0xd301428b, 0x1ac001cb, 0x09834152, 0xd301428b, 0x1ac0018b, 0x09434152, 0xd301428b, 0x1ac0014b,
    0x09034152, 0xd301428b, 0x1ac0010b, 0x08c34152, 0xd301428b, 0x1ac000cb, 0x08834152, 0xd301428b,
    0x1ac0008b, 0xd2d94152, 0x428b0843, 0x004bd301, 0x41521ac0, 0xd2001a41, 0x46634601, 0x105b4152,
    0xd3014610, 0x2b004240, 0x4249d500, 0x46634770, 0xd300105b, 0xb5014240, 0x46c02000, 0xbd0246c0,
    0x0c04b5f8, 0x4626b28b, 0x435eb282, 0x46100c0d, 0x43580c37, 0x19800436, 0x41792100, 0x436e4616,
    0x04360c37, 0x41791980, 0x436e4626, 0xbdf81989, 0x00000000, 0x00000000, 0x1f78a400, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x20000039,
    'pc_unInit': 0x2000013d,
    'pc_program_page': 0x20000173,
    'pc_erase_sector': 0x20000155,
    'pc_eraseAll': 0x20000141,

    'static_base' : 0x00000000 + 0x00000020 + 0x00000930,
    'begin_stack' : 0x20000c00,
    'begin_data' : 0x20000000 + 0x1000,
    'page_size' : 0x100,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x20001000, 0x20001100],   # Enable double buffering
    'min_program_length' : 0x100
}


class MIMXRT1062xxxxA(IMXRT):

    VENDOR = "NXP"

    # Note: itcm, dtcm, and ocram share a single 512 KB block of RAM that can be configurably
    # divided between those regions (this is called FlexRAM). Thus, the memory map regions for
    # each of these RAMs allocate the maximum possible of 512 KB, but that is the maximum and
    # will not actually be available in all regions simultaneously.
    memoryMap = MemoryMap(
        RamRegion(name="itcm",      start=0x00000000, length=0x80000), # 512 KB
        RomRegion(name="romcp",     start=0x00200000, length=0x20000),
        RamRegion(name="dtcm",      start=0x20000000, length=0x80000), # 512 KB
        RamRegion(name="ocram",     start=0x20200000, length=0x80000), # 512 KB
        FlashRegion(name="flexspi", start=0x60000000, length=0x800000, blocksize=0x10000, is_boot_memory=True,
            algo=FLASH_ALGO, page_size=0x100),
        RamRegion(name="semc",      start=0x80000000, length=0x1e00000, is_external=True), # external sdram
    )

    def __init__(self, link):
        super(MIMXRT1062xxxxA, self).__init__(link, self.memoryMap)
        self._svd_location = SVDFile.from_builtin("MIMXRT1062.xml")
