# pyOCD debugger
# Copyright (c) 2020 Nuvoton
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ...flash.flash import Flash
from ...coresight.coresight_target import CoreSightTarget
from ...core.memory_map import (FlashRegion, RamRegion, MemoryMap)
from ...debug.svd.loader import SVDFile

FLASH_ALGO_AP_SP = {
    'load_address' : 0x20000000,
    'instructions': [
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0xbf00b501, 0x1e419800, 0x28009100, 0xbd08d1fa, 0x41f0e92d, 0x460f4606, 0x25644690, 0x49fb2059,
    0x20166008, 0xf8c10589, 0x20880100, 0x0100f8c1, 0xf8d006c0, 0xf0000100, 0xb9100001, 0xe8bd2001,
    0x48f381f0, 0xf0406800, 0xf04f0004, 0xf8c14180, 0x46080200, 0x0204f8d0, 0x0004f040, 0x0204f8c1,
    0xf7ff2080, 0xf04fffcd, 0xf8d04080, 0x49e901f4, 0x70084449, 0xf04f48e8, 0xf8c14180, 0xbf000240,
    0x305048e3, 0xf0006800, 0x28000004, 0x48e0d0f8, 0x68043010, 0x0407f024, 0x0002f044, 0x4180f04f,
    0x0210f8c1, 0x7040f44f, 0xffaaf7ff, 0x680048db, 0x002df040, 0x600849d9, 0x68004608, 0x0001f000,
    0x2001b908, 0x48d5e7bb, 0xf0406800, 0x49d30040, 0x20006008, 0x4601e7b3, 0x48d0bf00, 0xf0006900,
    0x28000001, 0x48cdd1f9, 0xf0206800, 0x4acb002d, 0x48c76010, 0x68003010, 0x0007f040, 0x4280f04f,
    0x0210f8c2, 0x47702000, 0xbf004602, 0x30c048c3, 0xf0006800, 0x28000001, 0x48c0d1f8, 0xf0406800,
    0x4bbe0040, 0x20226018, 0x461860d8, 0xb9196042, 0x30fff04f, 0xe0026098, 0x4bb848b9, 0x20016098,
    0x61184bb6, 0x8f60f3bf, 0x48b4bf00, 0x680030c0, 0x0001f000, 0xd1f82800, 0x680048b0, 0x0040f000,
    0x48aeb138, 0xf0406800, 0x4bac0040, 0x20016018, 0x20004770, 0xb510e7fc, 0xf4044604, 0xf5b00070,
    0xd10e1f00, 0x444848a3, 0xb1287800, 0x1000f5a4, 0xf7ff2101, 0xbd10ffb9, 0x46202101, 0xffb4f7ff,
    0x2100e7f9, 0xf7ff4620, 0xe7f4ffaf, 0xbf004601, 0x6900489a, 0x0001f000, 0xd1f92800, 0x68004897,
    0x0040f040, 0x60104a95, 0x60d02025, 0x60414610, 0x1f00f5b1, 0x4892d101, 0x20016090, 0x61104a8f,
    0x8f60f3bf, 0x488dbf00, 0xf0006900, 0x28000001, 0x488ad1f9, 0xf0006800, 0xb1380040, 0x68004887,
    0x0040f040, 0x60104a85, 0x47702001, 0xe7fc2000, 0x4605b5f0, 0x2400460e, 0x487ee01e, 0x78004448,
    0xf835b988, 0xf3c00024, 0xb960000d, 0x28041b30, 0xf855d309, 0xf7ff0024, 0x1e07ffb9, 0x4638d001,
    0x1d24bdf0, 0xf855e008, 0xf7ff0024, 0x1e07ff94, 0x4638d001, 0x1c64e7f4, 0xd3de42b4, 0xe7ef2000,
    0x4604b570, 0x4615460b, 0x46292200, 0x000ff103, 0x030ff020, 0x4869bf00, 0xf0006900, 0x28000001,
    0x4866d1f9, 0xf0406800, 0x4e640040, 0xf0246030, 0x6070000f, 0x60f02027, 0x1c524610, 0x0020f851,
    0x36804e5e, 0x46106030, 0xf8511c52, 0x4e5b0020, 0x0084f8c6, 0x1c524610, 0x0020f851, 0x36884e57,
    0x46106030, 0xf8511c52, 0x1d360020, 0x20016030, 0x61304e52, 0xe02c3b10, 0x4850bf00, 0x680030c0,
    0x0030f000, 0xd1f82800, 0x1c524610, 0x0020f851, 0x36804e4a, 0x46106030, 0xf8511c52, 0x4e470020,
    0x0084f8c6, 0x4845bf00, 0x680030c0, 0x00c0f000, 0xd1f82800, 0x1c524610, 0x0020f851, 0x36884e3f,
    0x46106030, 0xf8511c52, 0x4e3c0020, 0x008cf8c6, 0x2b003b10, 0xbf00d1d0, 0x69004838, 0x0001f000,
    0xd1f92800, 0xb510bd70, 0x1cc84603, 0x0103f020, 0x4832bf00, 0xf0006900, 0x28000001, 0x482fd1f9,
    0xf0406800, 0x4c2d0040, 0x20216020, 0xe02060e0, 0x0003f023, 0x60604c29, 0x60a06810, 0x61202001,
    0x8f60f3bf, 0x4825bf00, 0xf0006900, 0x28000001, 0x4822d1f9, 0xf0006800, 0xb1380040, 0x6800481f,
    0x0040f040, 0x60204c1d, 0xbd102001, 0x1d121d1b, 0x29001f09, 0x2000d1dc, 0xe92de7f7, 0x460547f0,
    0x4616460c, 0x0800f04f, 0xbf0046c2, 0x69004813, 0x0001f000, 0xd1f92800, 0x68004810, 0x0040f040,
    0x6008490e, 0xf0201ce0, 0xe03b0403, 0x0008f3c5, 0xf5b4b9c0, 0xd3157f00, 0x7700f44f, 0x0208eb06,
    0x46284639, 0xff2cf7ff, 0xe0224682, 0x40000100, 0x40000200, 0x00000004, 0x0008421e, 0x4000c000,
    0x0055aa03, 0x0008f3c5, 0x2c10b958, 0xf024d309, 0xeb06070f, 0x46390208, 0xf7ff4628, 0x4682ff11,
    0x4627e007, 0x0208eb06, 0x46284639, 0xff7bf7ff, 0x443d4682, 0x1be444b8, 0x0f00f1ba, 0x2001d002,
    0x87f0e8bd, 0xd1c12c00, 0xe7f92000, 0x4603b510, 0xf0201cc8, 0xbf000103, 0x6900482f, 0x0001f000,
    0xd1f92800, 0x6800482c, 0x0040f040, 0x60204c2a, 0x60e02000, 0xf023e027, 0x4c270003, 0x20006060,
    0x200160a0, 0xf3bf6120, 0xbf008f60, 0x69004822, 0x0001f000, 0xd1f92800, 0x6800481f, 0x0040f000,
    0x481db138, 0xf0406800, 0x4c1b0040, 0x20016020, 0x4819bd10, 0x68146880, 0xd00142a0, 0xe7f72001,
    0x1d121d1b, 0x29001f09, 0x2000d1d5, 0xb510e7f0, 0x48114603, 0xf0006e00, 0xb1680002, 0x6503480e,
    0x65826541, 0x4c0c2001, 0xbf0065e0, 0x6e00480a, 0x0001f000, 0xd1f92800, 0x6e004807, 0x0004f000,
    0x2002b908, 0x4804bd10, 0xf0006e00, 0xb1080002, 0xe7f72001, 0xe7f52000, 0x4000c000, 0x00000000,
    0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x20000031,
    'pc_unInit': 0x200000f7,
    'pc_program_page': 0x200003db,
    'pc_erase_sector': 0x20000197,
    'pc_eraseAll': 0x0,

    'static_base' : 0x20000000 + 0x00000020 + 0x0000053c,
    'begin_stack' : 0x20000800,
    'begin_data' : 0x20000000 + 0x1000,
    'page_size' : 0x1000,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x20001000, 0x20002000],   # Enable double buffering
    'min_program_length' : 0x1000,
}

FLASH_ALGO_LD = {
    'load_address' : 0x20000000,
    'instructions': [
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0xbf00b501, 0x1e419800, 0x28009100, 0xbd08d1fa, 0x41f0e92d, 0x460f4606, 0x25644690, 0x49f82059,
    0x20166008, 0xf8c10589, 0x20880100, 0x0100f8c1, 0xf8d006c0, 0xf0000100, 0xb9100001, 0xe8bd2001,
    0x48f081f0, 0xf0406800, 0xf04f0004, 0xf8c14180, 0x46080200, 0x0204f8d0, 0x0004f040, 0x0204f8c1,
    0xf7ff2080, 0xf04fffcd, 0xf8d04080, 0x49e601f4, 0x70084449, 0xf04f48e5, 0xf8c14180, 0xbf000240,
    0x305048e0, 0xf0006800, 0x28000004, 0x48ddd0f8, 0x68043010, 0x0407f024, 0x0002f044, 0x4180f04f,
    0x0210f8c1, 0x7040f44f, 0xffaaf7ff, 0x680048d8, 0x002df040, 0x600849d6, 0x68004608, 0x0001f000,
    0x2001b908, 0x48d2e7bb, 0xf0006800, 0xb9080020, 0xe7b42001, 0x680048ce, 0x0040f040, 0x600849cc,
    0xe7ac2000, 0xbf004601, 0x690048c9, 0x0001f000, 0xd1f92800, 0x680048c6, 0x002df020, 0x60104ac4,
    0x301048c0, 0xf0406800, 0xf04f0007, 0xf8c24280, 0x20000210, 0x46034770, 0x47702001, 0xbf004602,
    0x30c048bb, 0xf0006800, 0x28000001, 0x48b8d1f8, 0xf0406800, 0x4bb60040, 0x20226018, 0x461860d8,
    0xb9196042, 0x30fff04f, 0xe0026098, 0x4bb048b1, 0x20016098, 0x61184bae, 0x8f60f3bf, 0x48acbf00,
    0x680030c0, 0x0001f000, 0xd1f82800, 0x680048a8, 0x0040f000, 0x48a6b138, 0xf0406800, 0x4ba40040,
    0x20016018, 0x20004770, 0xb510e7fc, 0xf4044604, 0xf5b00070, 0xd10e1f00, 0x4448489b, 0xb1287800,
    0x1000f5a4, 0xf7ff2101, 0xbd10ffb9, 0x46202101, 0xffb4f7ff, 0x2100e7f9, 0xf7ff4620, 0xe7f4ffaf,
    0xbf004601, 0x69004892, 0x0001f000, 0xd1f92800, 0x6800488f, 0x0040f040, 0x60104a8d, 0x60d02025,
    0x60414610, 0x1f00f5b1, 0x488ad101, 0x20016090, 0x61104a87, 0x8f60f3bf, 0x4885bf00, 0xf0006900,
    0x28000001, 0x4882d1f9, 0xf0006800, 0xb1380040, 0x6800487f, 0x0040f040, 0x60104a7d, 0x47702001,
    0xe7fc2000, 0x4605b5f0, 0x2400460e, 0x4876e01e, 0x78004448, 0xf835b988, 0xf3c00024, 0xb960000d,
    0x28041b30, 0xf855d309, 0xf7ff0024, 0x1e07ffb9, 0x4638d001, 0x1d24bdf0, 0xf855e008, 0xf7ff0024,
    0x1e07ff94, 0x4638d001, 0x1c64e7f4, 0xd3de42b4, 0xe7ef2000, 0x4604b570, 0x4615460b, 0x46292200,
    0x000ff103, 0x030ff020, 0x4861bf00, 0xf0006900, 0x28000001, 0x485ed1f9, 0xf0406800, 0x4e5c0040,
    0xf0246030, 0x6070000f, 0x60f02027, 0x1c524610, 0x0020f851, 0x36804e56, 0x46106030, 0xf8511c52,
    0x4e530020, 0x0084f8c6, 0x1c524610, 0x0020f851, 0x36884e4f, 0x46106030, 0xf8511c52, 0x1d360020,
    0x20016030, 0x61304e4a, 0xe02c3b10, 0x4848bf00, 0x680030c0, 0x0030f000, 0xd1f82800, 0x1c524610,
    0x0020f851, 0x36804e42, 0x46106030, 0xf8511c52, 0x4e3f0020, 0x0084f8c6, 0x483dbf00, 0x680030c0,
    0x00c0f000, 0xd1f82800, 0x1c524610, 0x0020f851, 0x36884e37, 0x46106030, 0xf8511c52, 0x4e340020,
    0x008cf8c6, 0x2b003b10, 0xbf00d1d0, 0x69004830, 0x0001f000, 0xd1f92800, 0xb510bd70, 0x1cc84603,
    0x0103f020, 0x482abf00, 0xf0006900, 0x28000001, 0x4827d1f9, 0xf0406800, 0x4c250040, 0x20216020,
    0xe02060e0, 0x0003f023, 0x60604c21, 0x60a06810, 0x61202001, 0x8f60f3bf, 0x481dbf00, 0xf0006900,
    0x28000001, 0x481ad1f9, 0xf0006800, 0xb1380040, 0x68004817, 0x0040f040, 0x60204c15, 0xbd102001,
    0x1d121d1b, 0x29001f09, 0x2000d1dc, 0xe92de7f7, 0x460547f0, 0x4616460c, 0x0800f04f, 0xbf0046c2,
    0x6900480b, 0x0001f000, 0xd1f92800, 0x68004808, 0x0040f040, 0x60084906, 0xf0201ce0, 0xe03b0403,
    0x40000100, 0x40000200, 0x00000004, 0x0008421e, 0x4000c000, 0x0055aa03, 0x0008f3c5, 0xf5b4b960,
    0xd3097f00, 0x7700f44f, 0x0208eb06, 0x46284639, 0xff20f7ff, 0xe0164682, 0x0008f3c5, 0x2c10b958,
    0xf024d309, 0xeb06070f, 0x46390208, 0xf7ff4628, 0x4682ff11, 0x4627e007, 0x0208eb06, 0x46284639,
    0xff7bf7ff, 0x443d4682, 0x1be444b8, 0x0f00f1ba, 0x2001d002, 0x87f0e8bd, 0xd1cd2c00, 0xe7f92000,
    0x4603b510, 0xf0201cc8, 0xbf000103, 0x6900482f, 0x0001f000, 0xd1f92800, 0x6800482c, 0x0040f040,
    0x60204c2a, 0x60e02000, 0xf023e027, 0x4c270003, 0x20006060, 0x200160a0, 0xf3bf6120, 0xbf008f60,
    0x69004822, 0x0001f000, 0xd1f92800, 0x6800481f, 0x0040f000, 0x481db138, 0xf0406800, 0x4c1b0040,
    0x20016020, 0x4819bd10, 0x68146880, 0xd00142a0, 0xe7f72001, 0x1d121d1b, 0x29001f09, 0x2000d1d5,
    0xb510e7f0, 0x48114603, 0xf0006e00, 0xb1680002, 0x6503480e, 0x65826541, 0x4c0c2001, 0xbf0065e0,
    0x6e00480a, 0x0001f000, 0xd1f92800, 0x6e004807, 0x0004f000, 0x2002b908, 0x4804bd10, 0xf0006e00,
    0xb1080002, 0xe7f72001, 0xe7f52000, 0x4000c000, 0x00000000, 0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x20000031,
    'pc_unInit': 0x20000105,
    'pc_program_page': 0x200003ef,
    'pc_erase_sector': 0x200001ab,
    'pc_eraseAll': 0x0,

    'static_base' : 0x20000000 + 0x00000020 + 0x00000550,
    'begin_stack' : 0x20000800,
    'begin_data' : 0x20000000 + 0x1000,
    'page_size' : 0x1000,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x20001000, 0x20002000],   # Enable double buffering
    'min_program_length' : 0x1000,
}

class M487JIDAE(CoreSightTarget):
    VENDOR = "Nuvoton"

    MEMORY_MAP = MemoryMap(
        FlashRegion( start=0x00000000, length=0x80000,  sector_size=0x1000,
                                                        page_size=0x1000,
                                                        is_boot_memory=True,
                                                        algo=FLASH_ALGO_AP_SP),
        FlashRegion( start=0x00100000, length=0x1000,   sector_size=0x1000,
                                                        page_size=0x1000,
                                                        algo=FLASH_ALGO_LD),
        FlashRegion( start=0x00200000, length=0x1000,   sector_size=0x1000,
                                                        page_size=0x1000,
                                                        algo=FLASH_ALGO_AP_SP),
        RamRegion(   start=0x20000000, length=0x28000)
        )

    def __init__(self, session):
        super(M487JIDAE, self).__init__(session, self.MEMORY_MAP)
        self._svd_location = SVDFile.from_builtin("M480_v1.svd")
