cdef extern from "synthizer_constants.h":

    cdef enum SYZ_OBJECT_TYPE:
        SYZ_OTYPE_CONTEXT
        SYZ_OTYPE_BUFFER
        SYZ_OTYPE_BUFFER_GENERATOR
        SYZ_OTYPE_STREAMING_GENERATOR
        SYZ_OTYPE_NOISE_GENERATOR
        SYZ_OTYPE_DIRECT_SOURCE
        SYZ_OTYPE_ANGULAR_PANNED_SOURCE
        SYZ_OTYPE_SCALAR_PANNED_SOURCE
        SYZ_OTYPE_SOURCE_3D
        SYZ_OTYPE_GLOBAL_ECHO
        SYZ_OTYPE_GLOBAL_FDN_REVERB
        SYZ_OTYPE_STREAM_HANDLE
        SYZ_OTYPE_AUTOMATION_BATCH

    cdef enum SYZ_PANNER_STRATEGY:
        SYZ_PANNER_STRATEGY_DELEGATE
        SYZ_PANNER_STRATEGY_HRTF
        SYZ_PANNER_STRATEGY_STEREO
        SYZ_PANNER_STRATEGY_COUNT

    cdef enum SYZ_DISTANCE_MODEL:
        SYZ_DISTANCE_MODEL_NONE
        SYZ_DISTANCE_MODEL_LINEAR
        SYZ_DISTANCE_MODEL_EXPONENTIAL
        SYZ_DISTANCE_MODEL_INVERSE
        SYZ_DISTANCE_MODEL_COUNT

    cdef enum SYZ_NOISE_TYPE:
        SYZ_NOISE_TYPE_UNIFORM
        SYZ_NOISE_TYPE_VM
        SYZ_NOISE_TYPE_FILTERED_BROWN
        SYZ_NOISE_TYPE_COUNT

    cdef enum SYZ_PROPERTIES:
        SYZ_P_AZIMUTH
        SYZ_P_BUFFER
        SYZ_P_ELEVATION
        SYZ_P_GAIN
        SYZ_P_DEFAULT_PANNER_STRATEGY
        SYZ_P_PANNING_SCALAR
        SYZ_P_PLAYBACK_POSITION
        SYZ_P_POSITION
        SYZ_P_ORIENTATION
        SYZ_P_CLOSENESS_BOOST
        SYZ_P_CLOSENESS_BOOST_DISTANCE
        SYZ_P_DISTANCE_MAX
        SYZ_P_DISTANCE_MODEL
        SYZ_P_DISTANCE_REF
        SYZ_P_ROLLOFF
        SYZ_P_DEFAULT_CLOSENESS_BOOST
        SYZ_P_DEFAULT_CLOSENESS_BOOST_DISTANCE
        SYZ_P_DEFAULT_DISTANCE_MAX
        SYZ_P_DEFAULT_DISTANCE_MODEL
        SYZ_P_DEFAULT_DISTANCE_REF
        SYZ_P_DEFAULT_ROLLOFF
        SYZ_P_LOOPING
        SYZ_P_NOISE_TYPE
        SYZ_P_PITCH_BEND
        SYZ_P_INPUT_FILTER_ENABLED
        SYZ_P_INPUT_FILTER_CUTOFF
        SYZ_P_MEAN_FREE_PATH
        SYZ_P_T60
        SYZ_P_LATE_REFLECTIONS_LF_ROLLOFF
        SYZ_P_LATE_REFLECTIONS_LF_REFERENCE
        SYZ_P_LATE_REFLECTIONS_HF_ROLLOFF
        SYZ_P_LATE_REFLECTIONS_HF_REFERENCE
        SYZ_P_LATE_REFLECTIONS_DIFFUSION
        SYZ_P_LATE_REFLECTIONS_MODULATION_DEPTH
        SYZ_P_LATE_REFLECTIONS_MODULATION_FREQUENCY
        SYZ_P_LATE_REFLECTIONS_DELAY
        SYZ_P_FILTER
        SYZ_P_FILTER_DIRECT
        SYZ_P_FILTER_EFFECTS
        SYZ_P_FILTER_INPUT
        SYZ_P_CURRENT_TIME
        SYZ_P_SUGGESTED_AUTOMATION_TIME

    cdef enum SYZ_EVENT_TYPES:
        SYZ_EVENT_TYPE_INVALID
        SYZ_EVENT_TYPE_LOOPED
        SYZ_EVENT_TYPE_FINISHED
        SYZ_EVENT_TYPE_USER_AUTOMATION

    cdef enum SYZ_INTERPOLATION_TYPES:
        SYZ_INTERPOLATION_TYPE_NONE
        SYZ_INTERPOLATION_TYPE_LINEAR

    cdef enum SYZ_AUTOMATION_COMMANDS:
        SYZ_AUTOMATION_COMMAND_APPEND_PROPERTY
        SYZ_AUTOMATION_COMMAND_SEND_USER_EVENT
        SYZ_AUTOMATION_COMMAND_CLEAR_PROPERTY
        SYZ_AUTOMATION_COMMAND_CLEAR_EVENTS
        SYZ_AUTOMATION_COMMAND_CLEAR_ALL_PROPERTIES
