# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_file.configuration import Configuration


class FileFilePublication(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'repository_version': 'str',
        'repository': 'str',
        'manifest': 'str'
    }

    attribute_map = {
        'repository_version': 'repository_version',
        'repository': 'repository',
        'manifest': 'manifest'
    }

    def __init__(self, repository_version=None, repository=None, manifest='PULP_MANIFEST', local_vars_configuration=None):  # noqa: E501
        """FileFilePublication - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._repository_version = None
        self._repository = None
        self._manifest = None
        self.discriminator = None

        if repository_version is not None:
            self.repository_version = repository_version
        if repository is not None:
            self.repository = repository
        self.manifest = manifest

    @property
    def repository_version(self):
        """Gets the repository_version of this FileFilePublication.  # noqa: E501


        :return: The repository_version of this FileFilePublication.  # noqa: E501
        :rtype: str
        """
        return self._repository_version

    @repository_version.setter
    def repository_version(self, repository_version):
        """Sets the repository_version of this FileFilePublication.


        :param repository_version: The repository_version of this FileFilePublication.  # noqa: E501
        :type: str
        """

        self._repository_version = repository_version

    @property
    def repository(self):
        """Gets the repository of this FileFilePublication.  # noqa: E501

        A URI of the repository to be published.  # noqa: E501

        :return: The repository of this FileFilePublication.  # noqa: E501
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """Sets the repository of this FileFilePublication.

        A URI of the repository to be published.  # noqa: E501

        :param repository: The repository of this FileFilePublication.  # noqa: E501
        :type: str
        """

        self._repository = repository

    @property
    def manifest(self):
        """Gets the manifest of this FileFilePublication.  # noqa: E501

        Filename to use for manifest file containing metadata for all the files.  # noqa: E501

        :return: The manifest of this FileFilePublication.  # noqa: E501
        :rtype: str
        """
        return self._manifest

    @manifest.setter
    def manifest(self, manifest):
        """Sets the manifest of this FileFilePublication.

        Filename to use for manifest file containing metadata for all the files.  # noqa: E501

        :param manifest: The manifest of this FileFilePublication.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                manifest is not None and len(manifest) < 1):
            raise ValueError("Invalid value for `manifest`, length must be greater than or equal to `1`")  # noqa: E501

        self._manifest = manifest

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileFilePublication):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FileFilePublication):
            return True

        return self.to_dict() != other.to_dict()
