/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import java.io.Serializable;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spire.math.Algebraic$;
import spire.math.Bounded;
import spire.math.Interval;
import spire.math.Point;
import spire.math.Polynomial;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.Real;
import spire.math.Real$;
import spire.math.poly.RootIsolator$;
import spire.math.poly.Roots;
import spire.math.poly.Roots$;

@ScalaSignature(bytes="\u0006\u0001=3Q!\u0001\u0002\u0001\u0005!\u0011aBR5yK\u0012\u0014V-\u00197S_>$8O\u0003\u0002\u0004\t\u0005!\u0001o\u001c7z\u0015\t)a!\u0001\u0003nCRD'\"A\u0004\u0002\u000bM\u0004\u0018N]3\u0014\u0007\u0001Iq\u0002\u0005\u0002\u000b\u001b5\t1BC\u0001\r\u0003\u0015\u00198-\u00197b\u0013\tq1B\u0001\u0004B]f\u0014VM\u001a\t\u0004!E\u0019R\"\u0001\u0002\n\u0005I\u0011!!\u0002*p_R\u001c\bC\u0001\u000b\u0016\u001b\u0005!\u0011B\u0001\f\u0005\u0005\u0011\u0011V-\u00197\t\u0011\r\u0001!Q1A\u0005\u0002e\u0019\u0001!F\u0001\u001b!\r!2dE\u0005\u00039\u0011\u0011!\u0002U8ms:|W.[1m\u0011!q\u0002A!A!\u0002\u0013Q\u0012!\u00029pYf\u0004\u0003\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\b\u0006\u0002#GA\u0011\u0001\u0003\u0001\u0005\u0006\u0007}\u0001\rA\u0007\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u0003\u0015Q\bo\u001c7z+\u00059\u0003c\u0001\u000b\u001cQA\u0011\u0011&\r\b\u0003U=r!a\u000b\u0018\u000e\u00031R!!\f\r\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0011B\u0001\u0019\f\u0003\u001d\u0001\u0018mY6bO\u0016L!AM\u001a\u0003\r\tKw-\u00138u\u0015\t\u00014\u0002\u0003\u00046\u0001\u0001\u0006IaJ\u0001\u0007uB|G.\u001f\u0011\t\u000f]\u0002!\u0019!C\u0005q\u0005A\u0011n]8mCR,G-F\u0001:!\rI#\bP\u0005\u0003wM\u0012aAV3di>\u0014\bc\u0001\u000b>\u007f%\u0011a\b\u0002\u0002\t\u0013:$XM\u001d<bYB\u0011A\u0003Q\u0005\u0003\u0003\u0012\u0011\u0001BU1uS>t\u0017\r\u001c\u0005\u0007\u0007\u0002\u0001\u000b\u0011B\u001d\u0002\u0013%\u001cx\u000e\\1uK\u0012\u0004\u0003\"B#\u0001\t\u00031\u0015!B2pk:$X#A$\u0011\u0005)A\u0015BA%\f\u0005\rIe\u000e\u001e\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0004O\u0016$HCA\nN\u0011\u0015q%\n1\u0001H\u0003\u0005I\u0007")
public class FixedRealRoots
implements Roots<Real> {
    private final Polynomial<Real> poly;
    private final Polynomial<BigInt> zpoly;
    private final Vector<Interval<Rational>> isolated;

    @Override
    public Iterator<Real> iterator() {
        return Roots.iterator$(this);
    }

    @Override
    public int size() {
        return Roots.size$(this);
    }

    @Override
    public String toString() {
        return Roots.toString$(this);
    }

    @Override
    public GenericCompanion<Iterable> companion() {
        return Iterable.companion$(this);
    }

    @Override
    public Iterable<Real> seq() {
        return Iterable.seq$(this);
    }

    @Override
    public Iterable<Real> thisCollection() {
        return IterableLike.thisCollection$(this);
    }

    @Override
    public Iterable toCollection(Object repr) {
        return IterableLike.toCollection$(this, repr);
    }

    @Override
    public <U> void foreach(Function1<Real, U> f) {
        IterableLike.foreach$(this, f);
    }

    @Override
    public boolean forall(Function1<Real, Object> p) {
        return IterableLike.forall$(this, p);
    }

    @Override
    public boolean exists(Function1<Real, Object> p) {
        return IterableLike.exists$(this, p);
    }

    @Override
    public Option<Real> find(Function1<Real, Object> p) {
        return IterableLike.find$(this, p);
    }

    @Override
    public boolean isEmpty() {
        return IterableLike.isEmpty$(this);
    }

    @Override
    public <B> B foldRight(B z, Function2<Real, B, B> op) {
        return (B)IterableLike.foldRight$(this, z, op);
    }

    @Override
    public <B> B reduceRight(Function2<Real, B, B> op) {
        return (B)IterableLike.reduceRight$(this, op);
    }

    @Override
    public Iterable<Real> toIterable() {
        return IterableLike.toIterable$(this);
    }

    @Override
    public Iterator<Real> toIterator() {
        return IterableLike.toIterator$(this);
    }

    @Override
    public Object head() {
        return IterableLike.head$(this);
    }

    @Override
    public Object slice(int from, int until) {
        return IterableLike.slice$(this, from, until);
    }

    @Override
    public Object take(int n) {
        return IterableLike.take$(this, n);
    }

    @Override
    public Object drop(int n) {
        return IterableLike.drop$(this, n);
    }

    @Override
    public Object takeWhile(Function1 p) {
        return IterableLike.takeWhile$(this, p);
    }

    @Override
    public Iterator<Iterable<Real>> grouped(int size) {
        return IterableLike.grouped$(this, size);
    }

    @Override
    public Iterator<Iterable<Real>> sliding(int size) {
        return IterableLike.sliding$(this, size);
    }

    @Override
    public Iterator<Iterable<Real>> sliding(int size, int step) {
        return IterableLike.sliding$(this, size, step);
    }

    @Override
    public Object takeRight(int n) {
        return IterableLike.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return IterableLike.dropRight$(this, n);
    }

    @Override
    public <B> void copyToArray(Object xs, int start, int len) {
        IterableLike.copyToArray$(this, xs, start, len);
    }

    @Override
    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<Real>, Tuple2<A1, B>, That> bf) {
        return (That)IterableLike.zip$(this, that, bf);
    }

    @Override
    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<Real>, Tuple2<A1, B>, That> bf) {
        return (That)IterableLike.zipAll$(this, that, thisElem, thatElem, bf);
    }

    @Override
    public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<Real>, Tuple2<A1, Object>, That> bf) {
        return (That)IterableLike.zipWithIndex$(this, bf);
    }

    @Override
    public <B> boolean sameElements(GenIterable<B> that) {
        return IterableLike.sameElements$(this, that);
    }

    @Override
    public Stream<Real> toStream() {
        return IterableLike.toStream$(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return IterableLike.canEqual$(this, that);
    }

    @Override
    public IterableView<Real, Iterable<Real>> view() {
        return IterableLike.view$(this);
    }

    @Override
    public IterableView<Real, Iterable<Real>> view(int from, int until) {
        return IterableLike.view$(this, from, until);
    }

    @Override
    public Builder<Real, Iterable<Real>> newBuilder() {
        return GenericTraversableTemplate.newBuilder$(this);
    }

    @Override
    public <B> Builder<B, Iterable<B>> genericBuilder() {
        return GenericTraversableTemplate.genericBuilder$(this);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Real, Tuple2<A1, A2>> asPair) {
        return GenericTraversableTemplate.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Real, Tuple3<A1, A2, A3>> asTriple) {
        return GenericTraversableTemplate.unzip3$(this, asTriple);
    }

    @Override
    public GenTraversable flatten(Function1 asTraversable) {
        return GenericTraversableTemplate.flatten$(this, asTraversable);
    }

    @Override
    public GenTraversable transpose(Function1 asTraversable) {
        return GenericTraversableTemplate.transpose$(this, asTraversable);
    }

    @Override
    public Object repr() {
        return TraversableLike.repr$(this);
    }

    @Override
    public final boolean isTraversableAgain() {
        return TraversableLike.isTraversableAgain$(this);
    }

    @Override
    public Combiner<Real, ParIterable<Real>> parCombiner() {
        return TraversableLike.parCombiner$(this);
    }

    @Override
    public boolean hasDefiniteSize() {
        return TraversableLike.hasDefiniteSize$(this);
    }

    @Override
    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.$plus$plus$(this, that, bf);
    }

    @Override
    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
    }

    @Override
    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
    }

    @Override
    public <B, That> That map(Function1<Real, B> f, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.map$(this, f, bf);
    }

    @Override
    public <B, That> That flatMap(Function1<Real, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.flatMap$(this, f, bf);
    }

    @Override
    public Object filterImpl(Function1 p, boolean isFlipped) {
        return TraversableLike.filterImpl$(this, p, isFlipped);
    }

    @Override
    public Object filter(Function1 p) {
        return TraversableLike.filter$(this, p);
    }

    @Override
    public Object filterNot(Function1 p) {
        return TraversableLike.filterNot$(this, p);
    }

    @Override
    public <B, That> That collect(PartialFunction<Real, B> pf, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.collect$(this, pf, bf);
    }

    @Override
    public Tuple2<Iterable<Real>, Iterable<Real>> partition(Function1<Real, Object> p) {
        return TraversableLike.partition$(this, p);
    }

    @Override
    public <K> Map<K, Iterable<Real>> groupBy(Function1<Real, K> f) {
        return TraversableLike.groupBy$(this, f);
    }

    @Override
    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<Real>, B, That> cbf) {
        return (That)TraversableLike.scan$(this, z, op, cbf);
    }

    @Override
    public <B, That> That scanLeft(B z, Function2<B, Real, B> op, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.scanLeft$(this, z, op, bf);
    }

    @Override
    public <B, That> That scanRight(B z, Function2<Real, B, B> op, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.scanRight$(this, z, op, bf);
    }

    @Override
    public Option<Real> headOption() {
        return TraversableLike.headOption$(this);
    }

    @Override
    public Object tail() {
        return TraversableLike.tail$(this);
    }

    @Override
    public Object last() {
        return TraversableLike.last$(this);
    }

    @Override
    public Option<Real> lastOption() {
        return TraversableLike.lastOption$(this);
    }

    @Override
    public Object init() {
        return TraversableLike.init$(this);
    }

    @Override
    public Object sliceWithKnownDelta(int from, int until, int delta) {
        return TraversableLike.sliceWithKnownDelta$(this, from, until, delta);
    }

    @Override
    public Object sliceWithKnownBound(int from, int until) {
        return TraversableLike.sliceWithKnownBound$(this, from, until);
    }

    @Override
    public Object dropWhile(Function1 p) {
        return TraversableLike.dropWhile$(this, p);
    }

    @Override
    public Tuple2<Iterable<Real>, Iterable<Real>> span(Function1<Real, Object> p) {
        return TraversableLike.span$(this, p);
    }

    @Override
    public Tuple2<Iterable<Real>, Iterable<Real>> splitAt(int n) {
        return TraversableLike.splitAt$(this, n);
    }

    @Override
    public Iterator<Iterable<Real>> tails() {
        return TraversableLike.tails$(this);
    }

    @Override
    public Iterator<Iterable<Real>> inits() {
        return TraversableLike.inits$(this);
    }

    @Override
    public Traversable<Real> toTraversable() {
        return TraversableLike.toTraversable$(this);
    }

    @Override
    public <Col> Col to(CanBuildFrom<Nothing$, Real, Col> cbf) {
        return (Col)TraversableLike.to$(this, cbf);
    }

    @Override
    public String stringPrefix() {
        return TraversableLike.stringPrefix$(this);
    }

    @Override
    public FilterMonadic<Real, Iterable<Real>> withFilter(Function1<Real, Object> p) {
        return TraversableLike.withFilter$(this, p);
    }

    @Override
    public Parallel par() {
        return Parallelizable.par$(this);
    }

    @Override
    public List<Real> reversed() {
        return TraversableOnce.reversed$(this);
    }

    @Override
    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$(this);
    }

    @Override
    public int count(Function1<Real, Object> p) {
        return TraversableOnce.count$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(PartialFunction<Real, B> pf) {
        return TraversableOnce.collectFirst$(this, pf);
    }

    @Override
    public <B> B $div$colon(B z, Function2<B, Real, B> op) {
        return (B)TraversableOnce.$div$colon$(this, z, op);
    }

    @Override
    public <B> B $colon$bslash(B z, Function2<Real, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$(this, z, op);
    }

    @Override
    public <B> B foldLeft(B z, Function2<B, Real, B> op) {
        return (B)TraversableOnce.foldLeft$(this, z, op);
    }

    @Override
    public <B> B reduceLeft(Function2<B, Real, B> op) {
        return (B)TraversableOnce.reduceLeft$(this, op);
    }

    @Override
    public <B> Option<B> reduceLeftOption(Function2<B, Real, B> op) {
        return TraversableOnce.reduceLeftOption$(this, op);
    }

    @Override
    public <B> Option<B> reduceRightOption(Function2<Real, B, B> op) {
        return TraversableOnce.reduceRightOption$(this, op);
    }

    @Override
    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$(this, op);
    }

    @Override
    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$(this, op);
    }

    @Override
    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$(this, z, op);
    }

    @Override
    public <B> B aggregate(Function0<B> z, Function2<B, Real, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$(this, z, seqop, combop);
    }

    @Override
    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$(this, num);
    }

    @Override
    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$(this, num);
    }

    @Override
    public Object min(Ordering cmp) {
        return TraversableOnce.min$(this, cmp);
    }

    @Override
    public Object max(Ordering cmp) {
        return TraversableOnce.max$(this, cmp);
    }

    @Override
    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$(this, f, cmp);
    }

    @Override
    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$(this, f, cmp);
    }

    @Override
    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$(this, dest);
    }

    @Override
    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$(this, xs, start);
    }

    @Override
    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$(this, xs);
    }

    @Override
    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$(this, evidence$1);
    }

    @Override
    public List<Real> toList() {
        return TraversableOnce.toList$(this);
    }

    @Override
    public Seq<Real> toSeq() {
        return TraversableOnce.toSeq$(this);
    }

    @Override
    public IndexedSeq<Real> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$(this);
    }

    @Override
    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$(this);
    }

    @Override
    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$(this);
    }

    @Override
    public Vector<Real> toVector() {
        return TraversableOnce.toVector$(this);
    }

    @Override
    public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Real, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$(this, ev);
    }

    @Override
    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$(this, start, sep, end);
    }

    @Override
    public String mkString(String sep) {
        return TraversableOnce.mkString$(this, sep);
    }

    @Override
    public String mkString() {
        return TraversableOnce.mkString$(this);
    }

    @Override
    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$(this, b, start, sep, end);
    }

    @Override
    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$(this, b, sep);
    }

    @Override
    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$(this, b);
    }

    @Override
    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$(this);
    }

    @Override
    public Polynomial<Real> poly() {
        return this.poly;
    }

    private Polynomial<BigInt> zpoly() {
        return this.zpoly;
    }

    private Vector<Interval<Rational>> isolated() {
        return this.isolated;
    }

    @Override
    public int count() {
        return this.isolated().size();
    }

    @Override
    public Real get(int i) {
        Real real;
        if (i < 0 || i >= this.count()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(i)).toString());
        }
        Interval<Rational> interval = this.isolated().apply(i);
        if (interval instanceof Point) {
            Point point = (Point)interval;
            Rational value = (Rational)point.value();
            real = Real$.MODULE$.apply(value);
        } else if (interval instanceof Bounded) {
            Bounded bounded = (Bounded)interval;
            Rational lb = (Rational)bounded.lower();
            Rational ub = (Rational)bounded.upper();
            real = Real$.MODULE$.apply(Algebraic$.MODULE$.unsafeRoot(this.zpoly(), i, lb, ub).toBigDecimal(new MathContext(Real$.MODULE$.digits(), RoundingMode.HALF_EVEN)));
        } else {
            throw new RuntimeException("invalid isolated root interval");
        }
        return real;
    }

    public FixedRealRoots(Polynomial<Real> poly) {
        this.poly = poly;
        GenTraversableOnce.$init$(this);
        TraversableOnce.$init$(this);
        Parallelizable.$init$(this);
        TraversableLike.$init$(this);
        GenericTraversableTemplate.$init$(this);
        GenTraversable.$init$(this);
        Traversable.$init$(this);
        GenIterable.$init$(this);
        IterableLike.$init$(this);
        Iterable.$init$(this);
        Roots.$init$(this);
        this.zpoly = Roots$.MODULE$.removeFractions(poly.map((Function1<Real, Rational> & Serializable & scala.Serializable)x$2 -> x$2.toRational(), Rational$.MODULE$.RationalAlgebra(), Rational$.MODULE$.RationalAlgebra(), ClassTag$.MODULE$.apply(Rational.class), Real$.MODULE$.algebra(), Real$.MODULE$.algebra()));
        this.isolated = Roots$.MODULE$.isolateRoots(this.zpoly(), RootIsolator$.MODULE$.BigIntRootIsolator());
    }
}

