/*
 * Decompiled with CFR 0.152.
 */
package scorex.util;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteArrayBuilder {
    protected byte[] arr;
    protected ByteBuffer buf;

    public ByteArrayBuilder() {
        this(256);
    }

    public ByteArrayBuilder(int n) {
        this.arr = new byte[n];
        this.buf = ByteBuffer.wrap(this.arr);
    }

    public final byte[] array() {
        return this.arr;
    }

    public final int length() {
        return this.buf.position();
    }

    public final void setLength(int n) {
        this.buf.position(n);
    }

    public final int capacity() {
        return this.arr.length;
    }

    public final byte byteAt(int n) {
        return this.arr[n];
    }

    public final void crop(int n) {
        int n2 = this.buf.position();
        if (n < n2) {
            System.arraycopy(this.arr, n, this.arr, 0, n2 -= n);
        } else {
            n2 = 0;
        }
    }

    public final byte[] trim() {
        int n = this.buf.position();
        if (this.arr.length > n) {
            this.arr = Arrays.copyOf(this.arr, n);
            this.buf = ByteBuffer.wrap(this.arr);
        }
        return this.arr;
    }

    public final byte[] toBytes() {
        int n = this.buf.position();
        byte[] byArray = new byte[n];
        System.arraycopy(this.arr, 0, byArray, 0, n);
        return byArray;
    }

    public final ByteArrayBuilder append(byte by) {
        this.ensureCapacity(1);
        this.buf.put(by);
        return this;
    }

    public final ByteArrayBuilder append(byte[] byArray) {
        return this.append(byArray, 0, byArray.length);
    }

    public final ByteArrayBuilder append(byte[] byArray, int n, int n2) {
        this.ensureCapacity(n2);
        this.buf.put(byArray, n, n2);
        return this;
    }

    public final ByteArrayBuilder append(boolean bl) {
        this.append((byte)(bl ? 1 : 0));
        return this;
    }

    public final ByteArrayBuilder append(char c) {
        this.ensureCapacity(1);
        this.buf.putChar(c);
        return this;
    }

    public final ByteArrayBuilder append(short s) {
        this.ensureCapacity(2);
        this.buf.putShort(s);
        return this;
    }

    public final ByteArrayBuilder append(int n) {
        this.ensureCapacity(4);
        this.buf.putInt(n);
        return this;
    }

    public final ByteArrayBuilder append(long l) {
        this.ensureCapacity(8);
        this.buf.putLong(l);
        return this;
    }

    private void ensureCapacity(int n) {
        int n2 = this.buf.position();
        if (n2 + n > this.arr.length) {
            this.arr = Arrays.copyOf(this.arr, Math.max(n2 + n, this.arr.length << 1));
            this.newBuffer(this.arr);
        }
    }

    private void newBuffer(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(this.buf.position());
        this.buf = byteBuffer;
    }
}

