/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.restapi.client.ErgoTransactionDataInput;
import org.ergoplatform.restapi.client.ErgoTransactionInput;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;

@Schema(description="Transaction augmented with some useful information")
public class WalletTransaction {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="inputs")
    private List<ErgoTransactionInput> inputs = new ArrayList<ErgoTransactionInput>();
    @SerializedName(value="dataInputs")
    private List<ErgoTransactionDataInput> dataInputs = new ArrayList<ErgoTransactionDataInput>();
    @SerializedName(value="outputs")
    private List<ErgoTransactionOutput> outputs = new ArrayList<ErgoTransactionOutput>();
    @SerializedName(value="inclusionHeight")
    private Integer inclusionHeight = null;
    @SerializedName(value="numConfirmations")
    private Integer numConfirmations = null;
    @SerializedName(value="scans")
    private List<Integer> scans = new ArrayList<Integer>();
    @SerializedName(value="size")
    private Integer size = null;

    public WalletTransaction id(String string) {
        this.id = string;
        return this;
    }

    @Schema(description="")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public WalletTransaction inputs(List<ErgoTransactionInput> list) {
        this.inputs = list;
        return this;
    }

    public WalletTransaction addInputsItem(ErgoTransactionInput ergoTransactionInput) {
        this.inputs.add(ergoTransactionInput);
        return this;
    }

    @Schema(required=true, description="Transaction inputs")
    public List<ErgoTransactionInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<ErgoTransactionInput> list) {
        this.inputs = list;
    }

    public WalletTransaction dataInputs(List<ErgoTransactionDataInput> list) {
        this.dataInputs = list;
        return this;
    }

    public WalletTransaction addDataInputsItem(ErgoTransactionDataInput ergoTransactionDataInput) {
        this.dataInputs.add(ergoTransactionDataInput);
        return this;
    }

    @Schema(required=true, description="Transaction data inputs")
    public List<ErgoTransactionDataInput> getDataInputs() {
        return this.dataInputs;
    }

    public void setDataInputs(List<ErgoTransactionDataInput> list) {
        this.dataInputs = list;
    }

    public WalletTransaction outputs(List<ErgoTransactionOutput> list) {
        this.outputs = list;
        return this;
    }

    public WalletTransaction addOutputsItem(ErgoTransactionOutput ergoTransactionOutput) {
        this.outputs.add(ergoTransactionOutput);
        return this;
    }

    @Schema(required=true, description="Transaction outputs")
    public List<ErgoTransactionOutput> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ErgoTransactionOutput> list) {
        this.outputs = list;
    }

    public WalletTransaction inclusionHeight(Integer n) {
        this.inclusionHeight = n;
        return this;
    }

    @Schema(example="20998", required=true, description="Height of a block the transaction was included in")
    public Integer getInclusionHeight() {
        return this.inclusionHeight;
    }

    public void setInclusionHeight(Integer n) {
        this.inclusionHeight = n;
    }

    public WalletTransaction numConfirmations(Integer n) {
        this.numConfirmations = n;
        return this;
    }

    @Schema(example="20998", required=true, description="Number of transaction confirmations")
    public Integer getNumConfirmations() {
        return this.numConfirmations;
    }

    public void setNumConfirmations(Integer n) {
        this.numConfirmations = n;
    }

    public WalletTransaction scans(List<Integer> list) {
        this.scans = list;
        return this;
    }

    public WalletTransaction addScansItem(Integer n) {
        this.scans.add(n);
        return this;
    }

    @Schema(required=true, description="Scan identifiers the transaction relates to")
    public List<Integer> getScans() {
        return this.scans;
    }

    public void setScans(List<Integer> list) {
        this.scans = list;
    }

    public WalletTransaction size(Integer n) {
        this.size = n;
        return this;
    }

    @Schema(description="Size in bytes")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer n) {
        this.size = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WalletTransaction walletTransaction = (WalletTransaction)object;
        return Objects.equals(this.id, walletTransaction.id) && Objects.equals(this.inputs, walletTransaction.inputs) && Objects.equals(this.dataInputs, walletTransaction.dataInputs) && Objects.equals(this.outputs, walletTransaction.outputs) && Objects.equals(this.inclusionHeight, walletTransaction.inclusionHeight) && Objects.equals(this.numConfirmations, walletTransaction.numConfirmations) && Objects.equals(this.scans, walletTransaction.scans) && Objects.equals(this.size, walletTransaction.size);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.inputs, this.dataInputs, this.outputs, this.inclusionHeight, this.numConfirmations, this.scans, this.size);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class WalletTransaction {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        stringBuilder.append("    dataInputs: ").append(this.toIndentedString(this.dataInputs)).append("\n");
        stringBuilder.append("    outputs: ").append(this.toIndentedString(this.outputs)).append("\n");
        stringBuilder.append("    inclusionHeight: ").append(this.toIndentedString(this.inclusionHeight)).append("\n");
        stringBuilder.append("    numConfirmations: ").append(this.toIndentedString(this.numConfirmations)).append("\n");
        stringBuilder.append("    scans: ").append(this.toIndentedString(this.scans)).append("\n");
        stringBuilder.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

