/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.restapi.client.AnyOfRequestsHolderRequestsItems;

@Schema(description="Holds many transaction requests and transaction fee")
public class RequestsHolder {
    @SerializedName(value="requests")
    private List<AnyOfRequestsHolderRequestsItems> requests = new ArrayList<AnyOfRequestsHolderRequestsItems>();
    @SerializedName(value="fee")
    private Long fee = null;
    @SerializedName(value="inputsRaw")
    private List<String> inputsRaw = null;
    @SerializedName(value="dataInputsRaw")
    private List<String> dataInputsRaw = null;

    public RequestsHolder requests(List<AnyOfRequestsHolderRequestsItems> list) {
        this.requests = list;
        return this;
    }

    public RequestsHolder addRequestsItem(AnyOfRequestsHolderRequestsItems anyOfRequestsHolderRequestsItems) {
        this.requests.add(anyOfRequestsHolderRequestsItems);
        return this;
    }

    @Schema(required=true, description="Sequence of transaction requests")
    public List<AnyOfRequestsHolderRequestsItems> getRequests() {
        return this.requests;
    }

    public void setRequests(List<AnyOfRequestsHolderRequestsItems> list) {
        this.requests = list;
    }

    public RequestsHolder fee(Long l) {
        this.fee = l;
        return this;
    }

    @Schema(example="1000000", description="Transaction fee")
    public Long getFee() {
        return this.fee;
    }

    public void setFee(Long l) {
        this.fee = l;
    }

    public RequestsHolder inputsRaw(List<String> list) {
        this.inputsRaw = list;
        return this;
    }

    public RequestsHolder addInputsRawItem(String string) {
        if (this.inputsRaw == null) {
            this.inputsRaw = new ArrayList<String>();
        }
        this.inputsRaw.add(string);
        return this;
    }

    @Schema(description="List of inputs to be used in serialized form")
    public List<String> getInputsRaw() {
        return this.inputsRaw;
    }

    public void setInputsRaw(List<String> list) {
        this.inputsRaw = list;
    }

    public RequestsHolder dataInputsRaw(List<String> list) {
        this.dataInputsRaw = list;
        return this;
    }

    public RequestsHolder addDataInputsRawItem(String string) {
        if (this.dataInputsRaw == null) {
            this.dataInputsRaw = new ArrayList<String>();
        }
        this.dataInputsRaw.add(string);
        return this;
    }

    @Schema(description="List of data inputs to be used in serialized form")
    public List<String> getDataInputsRaw() {
        return this.dataInputsRaw;
    }

    public void setDataInputsRaw(List<String> list) {
        this.dataInputsRaw = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RequestsHolder requestsHolder = (RequestsHolder)object;
        return Objects.equals(this.requests, requestsHolder.requests) && Objects.equals(this.fee, requestsHolder.fee) && Objects.equals(this.inputsRaw, requestsHolder.inputsRaw) && Objects.equals(this.dataInputsRaw, requestsHolder.dataInputsRaw);
    }

    public int hashCode() {
        return Objects.hash(this.requests, this.fee, this.inputsRaw, this.dataInputsRaw);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class RequestsHolder {\n");
        stringBuilder.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        stringBuilder.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        stringBuilder.append("    inputsRaw: ").append(this.toIndentedString(this.inputsRaw)).append("\n");
        stringBuilder.append("    dataInputsRaw: ").append(this.toIndentedString(this.dataInputsRaw)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

