/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.SigmaBoolean;

@Schema(description="request to extract prover hints from a transaction")
public class HintExtractionRequest {
    @SerializedName(value="tx")
    private ErgoTransaction tx = null;
    @SerializedName(value="real")
    private List<SigmaBoolean> real = new ArrayList<SigmaBoolean>();
    @SerializedName(value="simulated")
    private List<SigmaBoolean> simulated = new ArrayList<SigmaBoolean>();
    @SerializedName(value="inputsRaw")
    private List<String> inputsRaw = null;
    @SerializedName(value="dataInputsRaw")
    private List<String> dataInputsRaw = null;

    public HintExtractionRequest tx(ErgoTransaction ergoTransaction) {
        this.tx = ergoTransaction;
        return this;
    }

    @Schema(required=true, description="")
    public ErgoTransaction getTx() {
        return this.tx;
    }

    public void setTx(ErgoTransaction ergoTransaction) {
        this.tx = ergoTransaction;
    }

    public HintExtractionRequest real(List<SigmaBoolean> list) {
        this.real = list;
        return this;
    }

    public HintExtractionRequest addRealItem(SigmaBoolean sigmaBoolean) {
        this.real.add(sigmaBoolean);
        return this;
    }

    @Schema(required=true, description="Real signers of the transaction")
    public List<SigmaBoolean> getReal() {
        return this.real;
    }

    public void setReal(List<SigmaBoolean> list) {
        this.real = list;
    }

    public HintExtractionRequest simulated(List<SigmaBoolean> list) {
        this.simulated = list;
        return this;
    }

    public HintExtractionRequest addSimulatedItem(SigmaBoolean sigmaBoolean) {
        this.simulated.add(sigmaBoolean);
        return this;
    }

    @Schema(required=true, description="Simulated signers of the transaction")
    public List<SigmaBoolean> getSimulated() {
        return this.simulated;
    }

    public void setSimulated(List<SigmaBoolean> list) {
        this.simulated = list;
    }

    public HintExtractionRequest inputsRaw(List<String> list) {
        this.inputsRaw = list;
        return this;
    }

    public HintExtractionRequest addInputsRawItem(String string) {
        if (this.inputsRaw == null) {
            this.inputsRaw = new ArrayList<String>();
        }
        this.inputsRaw.add(string);
        return this;
    }

    @Schema(description="Optional list of inputs to be used in serialized form")
    public List<String> getInputsRaw() {
        return this.inputsRaw;
    }

    public void setInputsRaw(List<String> list) {
        this.inputsRaw = list;
    }

    public HintExtractionRequest dataInputsRaw(List<String> list) {
        this.dataInputsRaw = list;
        return this;
    }

    public HintExtractionRequest addDataInputsRawItem(String string) {
        if (this.dataInputsRaw == null) {
            this.dataInputsRaw = new ArrayList<String>();
        }
        this.dataInputsRaw.add(string);
        return this;
    }

    @Schema(description="Optional list of inputs to be used in serialized form")
    public List<String> getDataInputsRaw() {
        return this.dataInputsRaw;
    }

    public void setDataInputsRaw(List<String> list) {
        this.dataInputsRaw = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HintExtractionRequest hintExtractionRequest = (HintExtractionRequest)object;
        return Objects.equals(this.tx, hintExtractionRequest.tx) && Objects.equals(this.real, hintExtractionRequest.real) && Objects.equals(this.simulated, hintExtractionRequest.simulated) && Objects.equals(this.inputsRaw, hintExtractionRequest.inputsRaw) && Objects.equals(this.dataInputsRaw, hintExtractionRequest.dataInputsRaw);
    }

    public int hashCode() {
        return Objects.hash(this.tx, this.real, this.simulated, this.inputsRaw, this.dataInputsRaw);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class HintExtractionRequest {\n");
        stringBuilder.append("    tx: ").append(this.toIndentedString(this.tx)).append("\n");
        stringBuilder.append("    real: ").append(this.toIndentedString(this.real)).append("\n");
        stringBuilder.append("    simulated: ").append(this.toIndentedString(this.simulated)).append("\n");
        stringBuilder.append("    inputsRaw: ").append(this.toIndentedString(this.inputsRaw)).append("\n");
        stringBuilder.append("    dataInputsRaw: ").append(this.toIndentedString(this.dataInputsRaw)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

