/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.Gson;
import java.text.DateFormat;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.ergoplatform.restapi.client.GsonCustomConverterFactory;
import org.ergoplatform.restapi.client.JSON;
import org.ergoplatform.restapi.client.auth.ApiKeyAuth;
import org.ergoplatform.restapi.client.auth.HttpBasicAuth;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ApiClient {
    private String _hostUrl;
    private Map<String, Interceptor> apiAuthorizations;
    private OkHttpClient.Builder okBuilder;
    private Retrofit.Builder adapterBuilder;
    private JSON json;

    public Gson getGson() {
        return this.json.getGson();
    }

    public ApiClient(String string) {
        this._hostUrl = string;
        this.apiAuthorizations = new LinkedHashMap<String, Interceptor>();
        this.createDefaultAdapter();
    }

    public ApiClient(String string, String[] stringArray) {
        this(string);
        for (String string2 : stringArray) {
            if (!"ApiKeyAuth".equals(string2)) {
                throw new RuntimeException("auth name \"" + string2 + "\" not found in available auth names");
            }
            ApiKeyAuth apiKeyAuth = new ApiKeyAuth("header", "api_key");
            this.addAuthorization(string2, apiKeyAuth);
        }
    }

    public ApiClient(String string, String string2) {
        this(string, new String[]{string2});
    }

    public ApiClient(String string, String string2, String string3) {
        this(string, string2);
        this.setApiKey(string3);
    }

    public ApiClient(String string, String string2, String string3, String string4) {
        this(string, string2);
        this.setCredentials(string3, string4);
    }

    public ApiClient(String string, String string2, String string3, String string4, String string5, String string6) {
        this(string, string2);
    }

    public void createDefaultAdapter() {
        this.json = new JSON();
        this.okBuilder = new OkHttpClient.Builder();
        if (!this._hostUrl.endsWith("/")) {
            this._hostUrl = this._hostUrl + "/";
        }
        this.adapterBuilder = new Retrofit.Builder().baseUrl(this._hostUrl).addConverterFactory(ScalarsConverterFactory.create()).addConverterFactory(GsonCustomConverterFactory.create(this.json.getGson()));
    }

    public <S> S createService(Class<S> clazz) {
        return this.adapterBuilder.client(this.okBuilder.build()).build().create(clazz);
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.json.setDateFormat(dateFormat);
        return this;
    }

    public ApiClient setSqlDateFormat(DateFormat dateFormat) {
        this.json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ApiClient setOffsetDateTimeFormat(DateTimeFormatter dateTimeFormatter) {
        this.json.setOffsetDateTimeFormat(dateTimeFormatter);
        return this;
    }

    public ApiClient setLocalDateFormat(DateTimeFormatter dateTimeFormatter) {
        this.json.setLocalDateFormat(dateTimeFormatter);
        return this;
    }

    public ApiClient setApiKey(String string) {
        for (Interceptor interceptor : this.apiAuthorizations.values()) {
            if (!(interceptor instanceof ApiKeyAuth)) continue;
            ApiKeyAuth apiKeyAuth = (ApiKeyAuth)interceptor;
            apiKeyAuth.setApiKey(string);
            return this;
        }
        return this;
    }

    public ApiClient setCredentials(String string, String string2) {
        for (Interceptor interceptor : this.apiAuthorizations.values()) {
            if (!(interceptor instanceof HttpBasicAuth)) continue;
            HttpBasicAuth httpBasicAuth = (HttpBasicAuth)interceptor;
            httpBasicAuth.setCredentials(string, string2);
            return this;
        }
        return this;
    }

    public ApiClient setAccessToken(String string) {
        return this;
    }

    public ApiClient addAuthorization(String string, Interceptor interceptor) {
        if (this.apiAuthorizations.containsKey(string)) {
            throw new RuntimeException("auth name \"" + string + "\" already in api authorizations");
        }
        this.apiAuthorizations.put(string, interceptor);
        this.okBuilder.addInterceptor(interceptor);
        return this;
    }

    public Map<String, Interceptor> getApiAuthorizations() {
        return this.apiAuthorizations;
    }

    public ApiClient setApiAuthorizations(Map<String, Interceptor> map2) {
        this.apiAuthorizations = map2;
        return this;
    }

    public Retrofit.Builder getAdapterBuilder() {
        return this.adapterBuilder;
    }

    public ApiClient setAdapterBuilder(Retrofit.Builder builder) {
        this.adapterBuilder = builder;
        return this;
    }

    public OkHttpClient.Builder getOkBuilder() {
        return this.okBuilder;
    }

    public void addAuthsToOkBuilder(OkHttpClient.Builder builder) {
        for (Interceptor interceptor : this.apiAuthorizations.values()) {
            builder.addInterceptor(interceptor);
        }
    }

    public void configureFromOkclient(OkHttpClient okHttpClient) {
        this.configureFromOkClientBuilder(okHttpClient.newBuilder());
    }

    public void configureFromOkClientBuilder(OkHttpClient.Builder builder) {
        this.okBuilder = builder;
        this.addAuthsToOkBuilder(this.okBuilder);
    }
}

