/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="References to previous and next (if exists) blocks")
public class BlockReferencesInfo {
    @SerializedName(value="previousId")
    private String previousId = null;
    @SerializedName(value="nextId")
    private String nextId = null;

    public BlockReferencesInfo previousId(String string) {
        this.previousId = string;
        return this;
    }

    @Schema(required=true, description="ID of the previous block")
    public String getPreviousId() {
        return this.previousId;
    }

    public void setPreviousId(String string) {
        this.previousId = string;
    }

    public BlockReferencesInfo nextId(String string) {
        this.nextId = string;
        return this;
    }

    @Schema(description="ID of the next block (if one exists)")
    public String getNextId() {
        return this.nextId;
    }

    public void setNextId(String string) {
        this.nextId = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BlockReferencesInfo blockReferencesInfo = (BlockReferencesInfo)object;
        return Objects.equals(this.previousId, blockReferencesInfo.previousId) && Objects.equals(this.nextId, blockReferencesInfo.nextId);
    }

    public int hashCode() {
        return Objects.hash(this.previousId, this.nextId);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class BlockReferencesInfo {\n");
        stringBuilder.append("    previousId: ").append(this.toIndentedString(this.previousId)).append("\n");
        stringBuilder.append("    nextId: ").append(this.toIndentedString(this.nextId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

