/*
 * Decompiled with CFR 0.152.
 */
package java7.compat;

public final class Math {
    public static int addExact(int n, int n2) {
        int n3 = n + n2;
        if (((n ^ n3) & (n2 ^ n3)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return n3;
    }

    public static long addExact(long l, long l2) {
        long l3 = l + l2;
        if (((l ^ l3) & (l2 ^ l3)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return l3;
    }

    public static int subtractExact(int n, int n2) {
        int n3 = n - n2;
        if (((n ^ n2) & (n ^ n3)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return n3;
    }

    public static long subtractExact(long l, long l2) {
        long l3 = l - l2;
        if (((l ^ l2) & (l ^ l3)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return l3;
    }

    public static int multiplyExact(int n, int n2) {
        long l = (long)n * (long)n2;
        if ((long)((int)l) != l) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)l;
    }

    public static long multiplyExact(long l, long l2) {
        long l3;
        long l4 = l * l2;
        long l5 = java.lang.Math.abs(l);
        if ((l5 | (l3 = java.lang.Math.abs(l2))) >>> 31 != 0L && (l2 != 0L && l4 / l2 != l || l == Long.MIN_VALUE && l2 == -1L)) {
            throw new ArithmeticException("long overflow");
        }
        return l4;
    }
}

