"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const defaults = require("../index");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
require("@aws-cdk/assert/jest");
test('test DynamoEventSourceProps', () => {
    const props = defaults.DynamoEventSourceProps();
    expect(props).toEqual({
        startingPosition: "TRIM_HORIZON"
    });
});
test('test DynamoEventSourceProps override', () => {
    const myProps = {
        startingPosition: lambda.StartingPosition.LATEST,
        batchSize: 1
    };
    const props = defaults.DynamoEventSourceProps(myProps);
    expect(props).toEqual({
        batchSize: 1,
        startingPosition: "LATEST"
    });
});
test('test S3EventSourceProps w/ default props', () => {
    const props = defaults.S3EventSourceProps();
    expect(props).toEqual({
        events: ["s3:ObjectCreated:*"]
    });
});
test('test S3EventSourceProps w/ user props', () => {
    const s3EventSourceProps = {
        events: [
            s3.EventType.OBJECT_CREATED_POST
        ]
    };
    const props = defaults.S3EventSourceProps(s3EventSourceProps);
    expect(props).toEqual({
        events: ["s3:ObjectCreated:Post"]
    });
});
test('test KinesisEventSourceProps', () => {
    const props = defaults.KinesisEventSourceProps();
    expect(props).toEqual({
        startingPosition: "TRIM_HORIZON",
        bisectBatchOnError: true
    });
});
test('test KinesisEventSourceProps override', () => {
    const myProps = {
        startingPosition: lambda.StartingPosition.LATEST,
        batchSize: 5,
        retryAttempts: 3
    };
    const props = defaults.KinesisEventSourceProps(myProps);
    expect(props).toEqual({
        batchSize: 5,
        startingPosition: "LATEST",
        bisectBatchOnError: true,
        retryAttempts: 3
    });
});
//# sourceMappingURL=data:application/json;base64,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