"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lambda = require("@aws-cdk/aws-lambda");
const events = require("@aws-cdk/aws-events");
const defaults = require("../index");
require("@aws-cdk/assert/jest");
const aws_events_1 = require("@aws-cdk/aws-events");
const core_2 = require("@aws-cdk/core");
const utils_1 = require("../lib/utils");
test('snapshot test EventsRuleProps default params', () => {
    const stack = new core_1.Stack();
    const lambdaFunctionProps = {
        runtime: lambda.Runtime.NODEJS_12_X,
        handler: 'index.handler',
        code: lambda.Code.asset(`${__dirname}/lambda`)
    };
    const fn = defaults.deployLambdaFunction(stack, lambdaFunctionProps);
    const lambdaFunc = {
        bind: () => ({
            id: '',
            arn: fn.functionArn
        })
    };
    const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([lambdaFunc]);
    const eventsRuleProps = utils_1.overrideProps(defaultEventsRuleProps, {
        schedule: aws_events_1.Schedule.rate(core_2.Duration.minutes(5))
    });
    new events.Rule(stack, 'Events', eventsRuleProps);
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('test EventsRuleProps override ruleName and description', () => {
    const stack = new core_1.Stack();
    const lambdaFunc = {
        bind: () => ({
            id: '',
            arn: 'ARN'
        })
    };
    const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([lambdaFunc]);
    const eventsRuleProps = utils_1.overrideProps(defaultEventsRuleProps, {
        ruleName: 'test',
        description: 'hello world',
        schedule: aws_events_1.Schedule.rate(core_2.Duration.minutes(5))
    });
    new events.Rule(stack, 'Events', eventsRuleProps);
    expect(stack).toHaveResource('AWS::Events::Rule', {
        Description: "hello world",
        Name: "test",
        ScheduleExpression: "rate(5 minutes)",
        State: "ENABLED",
        Targets: [
            {
                Arn: "ARN",
                Id: "Target0"
            }
        ]
    });
});
test('test EventsRuleProps add more event targets', () => {
    const stack = new core_1.Stack();
    const lambdaFunc1 = {
        bind: () => ({
            id: '',
            arn: 'ARN1'
        })
    };
    const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([lambdaFunc1]);
    const lambdaFunc2 = {
        bind: () => ({
            id: '',
            arn: 'ARN2'
        })
    };
    const eventsRuleProps = utils_1.overrideProps(defaultEventsRuleProps, {
        targets: [lambdaFunc2],
        schedule: aws_events_1.Schedule.rate(core_2.Duration.minutes(5))
    }, true);
    new events.Rule(stack, 'Events', eventsRuleProps);
    expect(stack).toHaveResource('AWS::Events::Rule', {
        ScheduleExpression: "rate(5 minutes)",
        State: "ENABLED",
        Targets: [
            {
                Arn: "ARN1",
                Id: "Target0"
            },
            {
                Arn: "ARN2",
                Id: "Target1"
            }
        ]
    });
});
//# sourceMappingURL=data:application/json;base64,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