"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSourceProps = exports.S3EventSourceProps = exports.DynamoEventSourceProps = void 0;
const lambda = require("@aws-cdk/aws-lambda");
const utils_1 = require("./utils");
const s3 = require("@aws-cdk/aws-s3");
function DynamoEventSourceProps(_dynamoEventSourceProps) {
    const defaultDynamoEventSourceProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON
    };
    if (_dynamoEventSourceProps) {
        return utils_1.overrideProps(defaultDynamoEventSourceProps, _dynamoEventSourceProps);
    }
    else {
        return defaultDynamoEventSourceProps;
    }
}
exports.DynamoEventSourceProps = DynamoEventSourceProps;
function S3EventSourceProps(_s3EventSourceProps) {
    const defaultS3EventSourceProps = {
        events: [s3.EventType.OBJECT_CREATED]
    };
    if (_s3EventSourceProps) {
        return utils_1.overrideProps(defaultS3EventSourceProps, _s3EventSourceProps, false);
    }
    else {
        return defaultS3EventSourceProps;
    }
}
exports.S3EventSourceProps = S3EventSourceProps;
function KinesisEventSourceProps(_kinesisEventSourceProps) {
    const defaultKinesisEventSourceProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true
    };
    if (_kinesisEventSourceProps) {
        return utils_1.overrideProps(defaultKinesisEventSourceProps, _kinesisEventSourceProps, false);
    }
    else {
        return defaultKinesisEventSourceProps;
    }
}
exports.KinesisEventSourceProps = KinesisEventSourceProps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWV2ZW50LXNvdXJjZS1tYXBwaW5nLWRlZmF1bHRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLWV2ZW50LXNvdXJjZS1tYXBwaW5nLWRlZmF1bHRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7O0FBRUgsOENBQThDO0FBQzlDLG1DQUF3QztBQUV4QyxzQ0FBc0M7QUFFdEMsU0FBZ0Isc0JBQXNCLENBQUMsdUJBQWdEO0lBRW5GLE1BQU0sNkJBQTZCLEdBQUc7UUFDbEMsZ0JBQWdCLEVBQUUsTUFBTSxDQUFDLGdCQUFnQixDQUFDLFlBQVk7S0FDekQsQ0FBQztJQUVGLElBQUksdUJBQXVCLEVBQUU7UUFDekIsT0FBTyxxQkFBYSxDQUFDLDZCQUE2QixFQUFFLHVCQUF1QixDQUFDLENBQUM7S0FDaEY7U0FBTTtRQUNILE9BQU8sNkJBQTZCLENBQUM7S0FDeEM7QUFDTCxDQUFDO0FBWEQsd0RBV0M7QUFFRCxTQUFnQixrQkFBa0IsQ0FBQyxtQkFBd0M7SUFFdkUsTUFBTSx5QkFBeUIsR0FBdUI7UUFDbEQsTUFBTSxFQUFFLENBQUMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUM7S0FDeEMsQ0FBQztJQUVGLElBQUksbUJBQW1CLEVBQUU7UUFDckIsT0FBTyxxQkFBYSxDQUFDLHlCQUF5QixFQUFFLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxDQUFDO0tBQy9FO1NBQU07UUFDSCxPQUFPLHlCQUF5QixDQUFDO0tBQ3BDO0FBQ0wsQ0FBQztBQVhELGdEQVdDO0FBRUQsU0FBZ0IsdUJBQXVCLENBQUMsd0JBQWtEO0lBQ3RGLE1BQU0sOEJBQThCLEdBQUc7UUFDbkMsZ0JBQWdCLEVBQUUsTUFBTSxDQUFDLGdCQUFnQixDQUFDLFlBQVk7UUFDdEQsa0JBQWtCLEVBQUUsSUFBSTtLQUMzQixDQUFDO0lBRUYsSUFBSSx3QkFBd0IsRUFBRTtRQUMxQixPQUFPLHFCQUFhLENBQUMsOEJBQThCLEVBQUUsd0JBQXdCLEVBQUUsS0FBSyxDQUFDLENBQUM7S0FDekY7U0FBTTtRQUNILE9BQU8sOEJBQThCLENBQUM7S0FDekM7QUFDTCxDQUFDO0FBWEQsMERBV0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAxOSBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCB7IG92ZXJyaWRlUHJvcHMgfSBmcm9tICcuL3V0aWxzJztcbmltcG9ydCB7IER5bmFtb0V2ZW50U291cmNlUHJvcHMsIFMzRXZlbnRTb3VyY2VQcm9wcywgS2luZXNpc0V2ZW50U291cmNlUHJvcHMgfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhLWV2ZW50LXNvdXJjZXMnO1xuaW1wb3J0ICogYXMgczMgZnJvbSAnQGF3cy1jZGsvYXdzLXMzJztcblxuZXhwb3J0IGZ1bmN0aW9uIER5bmFtb0V2ZW50U291cmNlUHJvcHMoX2R5bmFtb0V2ZW50U291cmNlUHJvcHM/OiBEeW5hbW9FdmVudFNvdXJjZVByb3BzKSB7XG5cbiAgICBjb25zdCBkZWZhdWx0RHluYW1vRXZlbnRTb3VyY2VQcm9wcyA9IHtcbiAgICAgICAgc3RhcnRpbmdQb3NpdGlvbjogbGFtYmRhLlN0YXJ0aW5nUG9zaXRpb24uVFJJTV9IT1JJWk9OXG4gICAgfTtcblxuICAgIGlmIChfZHluYW1vRXZlbnRTb3VyY2VQcm9wcykge1xuICAgICAgICByZXR1cm4gb3ZlcnJpZGVQcm9wcyhkZWZhdWx0RHluYW1vRXZlbnRTb3VyY2VQcm9wcywgX2R5bmFtb0V2ZW50U291cmNlUHJvcHMpO1xuICAgIH0gZWxzZSB7XG4gICAgICAgIHJldHVybiBkZWZhdWx0RHluYW1vRXZlbnRTb3VyY2VQcm9wcztcbiAgICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBTM0V2ZW50U291cmNlUHJvcHMoX3MzRXZlbnRTb3VyY2VQcm9wcz86IFMzRXZlbnRTb3VyY2VQcm9wcykge1xuXG4gICAgY29uc3QgZGVmYXVsdFMzRXZlbnRTb3VyY2VQcm9wczogUzNFdmVudFNvdXJjZVByb3BzID0ge1xuICAgICAgICBldmVudHM6IFtzMy5FdmVudFR5cGUuT0JKRUNUX0NSRUFURURdXG4gICAgfTtcblxuICAgIGlmIChfczNFdmVudFNvdXJjZVByb3BzKSB7XG4gICAgICAgIHJldHVybiBvdmVycmlkZVByb3BzKGRlZmF1bHRTM0V2ZW50U291cmNlUHJvcHMsIF9zM0V2ZW50U291cmNlUHJvcHMsIGZhbHNlKTtcbiAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gZGVmYXVsdFMzRXZlbnRTb3VyY2VQcm9wcztcbiAgICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBLaW5lc2lzRXZlbnRTb3VyY2VQcm9wcyhfa2luZXNpc0V2ZW50U291cmNlUHJvcHM/OiBLaW5lc2lzRXZlbnRTb3VyY2VQcm9wcykge1xuICAgIGNvbnN0IGRlZmF1bHRLaW5lc2lzRXZlbnRTb3VyY2VQcm9wcyA9IHtcbiAgICAgICAgc3RhcnRpbmdQb3NpdGlvbjogbGFtYmRhLlN0YXJ0aW5nUG9zaXRpb24uVFJJTV9IT1JJWk9OLFxuICAgICAgICBiaXNlY3RCYXRjaE9uRXJyb3I6IHRydWVcbiAgICB9O1xuXG4gICAgaWYgKF9raW5lc2lzRXZlbnRTb3VyY2VQcm9wcykge1xuICAgICAgICByZXR1cm4gb3ZlcnJpZGVQcm9wcyhkZWZhdWx0S2luZXNpc0V2ZW50U291cmNlUHJvcHMsIF9raW5lc2lzRXZlbnRTb3VyY2VQcm9wcywgZmFsc2UpO1xuICAgIH0gZWxzZSB7XG4gICAgICAgIHJldHVybiBkZWZhdWx0S2luZXNpc0V2ZW50U291cmNlUHJvcHM7XG4gICAgfVxufVxuIl19