"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildKinesisStream = void 0;
// Imports
const kinesis = require("@aws-cdk/aws-kinesis");
const kinesis_streams_defaults_1 = require("./kinesis-streams-defaults");
const utils_1 = require("./utils");
function buildKinesisStream(scope, props) {
    // If props is undefined, define it
    props = (props === undefined) ? {} : props;
    if (props.existingStreamObj) {
        return props.existingStreamObj;
    }
    // Setup the stream properties
    let kinesisStreamProps;
    if (props.kinesisStreamProps) {
        // If property overrides have been provided, incorporate them and deploy
        kinesisStreamProps = utils_1.overrideProps(kinesis_streams_defaults_1.DefaultStreamProps, props.kinesisStreamProps);
    }
    else {
        // If no property overrides, deploy using the default configuration
        kinesisStreamProps = kinesis_streams_defaults_1.DefaultStreamProps;
    }
    // Create the stream and return
    return new kinesis.Stream(scope, 'KinesisStream', kinesisStreamProps);
}
exports.buildKinesisStream = buildKinesisStream;
//# sourceMappingURL=data:application/json;base64,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